/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.serializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessage;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.KeyValue;

@Internal
public class PulsarSchemaWrapper<IN>
implements PulsarSerializationSchema<IN> {
    private static final long serialVersionUID = -2567052498398184194L;
    private final PulsarSchema<IN> pulsarSchema;

    public PulsarSchemaWrapper(Schema<IN> schema) {
        this(new PulsarSchema<IN>(schema));
    }

    public PulsarSchemaWrapper(Schema<IN> schema, Class<IN> clazz) {
        this(new PulsarSchema<IN>(schema, clazz));
    }

    public <K, V> PulsarSchemaWrapper(Schema<KeyValue<K, V>> schema, Class<K> keyClass, Class<V> valueClass) {
        this(new PulsarSchema(schema, keyClass, valueClass));
    }

    public PulsarSchemaWrapper(PulsarSchema<IN> pulsarSchema) {
        this.pulsarSchema = pulsarSchema;
    }

    @Override
    public PulsarMessage<?> serialize(IN element, PulsarSinkContext sinkContext) {
        Schema<IN> schema = this.pulsarSchema.getPulsarSchema();
        if (sinkContext.isEnableSchemaEvolution()) {
            return PulsarMessage.builder(schema, element).build();
        }
        return PulsarMessage.builder(schema.encode(element)).build();
    }
}

