/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.router;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRouter;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.util.Preconditions;

@Internal
public class RoundRobinTopicRouter<IN>
implements TopicRouter<IN> {
    private static final long serialVersionUID = -1160533263474038206L;
    private final AtomicLong counter = new AtomicLong(0L);
    private final int partitionSwitchSize;

    public RoundRobinTopicRouter(SinkConfiguration configuration) {
        this.partitionSwitchSize = configuration.getPartitionSwitchSize();
        Preconditions.checkArgument((this.partitionSwitchSize > 0 ? 1 : 0) != 0);
    }

    @Override
    public TopicPartition route(IN in, String key, List<TopicPartition> partitions, PulsarSinkContext context) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"You should provide topics for routing topic by message key hash.");
        long counts = this.counter.getAndAdd(1L);
        long index = counts / (long)this.partitionSwitchSize % (long)partitions.size();
        int topicIndex = (int)(Math.abs(index) % Integer.MAX_VALUE);
        return partitions.get(topicIndex);
    }
}

