/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.utils;

import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClient;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;

@Internal
public final class PulsarTransactionUtils {
    private PulsarTransactionUtils() {
    }

    public static Transaction createTransaction(PulsarClient pulsarClient, long timeoutMs) throws PulsarClientException {
        try {
            return (Transaction)pulsarClient.newTransaction().withTransactionTimeout(timeoutMs, TimeUnit.MILLISECONDS).build().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException((Throwable)e);
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public static TransactionCoordinatorClient getTcClient(PulsarClient pulsarClient) {
        TransactionCoordinatorClientImpl coordinatorClient = ((PulsarClientImpl)pulsarClient).getTcClient();
        Preconditions.checkNotNull((Object)coordinatorClient, (String)"You haven't enable transaction in Pulsar client.");
        return coordinatorClient;
    }
}

