/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.metrics;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;

public class ProducerMetricsInterceptor
implements ProducerInterceptor {
    private final Counter numRecordsOutErrors;
    private final Counter numRecordsOutCounter;
    private final Counter numBytesOutCounter;

    public ProducerMetricsInterceptor(SinkWriterMetricGroup metricGroup) {
        this.numRecordsOutErrors = metricGroup.getNumRecordsOutErrorsCounter();
        this.numRecordsOutCounter = metricGroup.getIOMetricGroup().getNumRecordsOutCounter();
        this.numBytesOutCounter = metricGroup.getIOMetricGroup().getNumBytesOutCounter();
    }

    public void close() {
    }

    public boolean eligible(Message message) {
        return true;
    }

    public Message beforeSend(Producer producer, Message message) {
        return message;
    }

    public void onSendAcknowledgement(Producer producer, Message message, MessageId msgId, Throwable exception) {
        if (exception != null) {
            this.numRecordsOutErrors.inc(1L);
        } else {
            this.numRecordsOutCounter.inc(1L);
            this.numBytesOutCounter.inc((long)message.size());
        }
    }
}

