/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.deserializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;

@Internal
class PulsarSchemaWrapper<T>
implements PulsarDeserializationSchema<T> {
    private static final long serialVersionUID = -4864701207257059158L;
    private final PulsarSchema<T> pulsarSchema;

    public PulsarSchemaWrapper(PulsarSchema<T> pulsarSchema) {
        this.pulsarSchema = pulsarSchema;
    }

    @Override
    public void deserialize(Message<byte[]> message, Collector<T> out) throws Exception {
        Schema<T> schema = this.pulsarSchema.getPulsarSchema();
        byte[] bytes = message.getData();
        Object instance = schema.decode(bytes);
        out.collect(instance);
    }

    public TypeInformation<T> getProducedType() {
        SchemaInfo info = this.pulsarSchema.getSchemaInfo();
        return PulsarSchemaUtils.createTypeInformation(info);
    }
}

