/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableSet;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;

@Internal
public final class TopicNameUtils {
    private static final Pattern HEARTBEAT_NAMESPACE_PATTERN = Pattern.compile("pulsar/[^/]+/([^:]+:\\d+)");
    private static final Pattern HEARTBEAT_NAMESPACE_PATTERN_V2 = Pattern.compile("pulsar/([^:]+:\\d+)");
    private static final Pattern SLA_NAMESPACE_PATTERN = Pattern.compile("sla-monitor/[^/]+/([^:]+:\\d+)");
    private static final Set<String> EVENTS_TOPIC_NAMES = ImmutableSet.of((Object)"__change_events", (Object)"__transaction_buffer_snapshot");
    private static final String TRANSACTION_COORDINATOR_ASSIGN_PREFIX = TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"transaction_coordinator_assign").toString();
    private static final String TRANSACTION_COORDINATOR_LOG_PREFIX = TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"__transaction_log_").toString();
    private static final String PENDING_ACK_STORE_SUFFIX = "__transaction_pending_ack";
    private static final String PENDING_ACK_STORE_CURSOR_SUFFIX = "__pending_ack_state";

    private TopicNameUtils() {
    }

    public static String topicName(String topic) {
        return TopicName.get((String)topic).getPartitionedTopicName();
    }

    public static String topicNameWithPartition(String topic, int partitionId) {
        Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (String)"Illegal partition id %s", (Object[])new Object[]{partitionId});
        return TopicName.get((String)topic).getPartition(partitionId).toString();
    }

    public static boolean isPartition(String topic) {
        return TopicName.get((String)topic).isPartitioned();
    }

    public static List<String> distinctTopics(List<String> topics) {
        HashSet<String> fullTopics = new HashSet<String>();
        HashMap<String, List> partitionedTopics = new HashMap<String, List>();
        for (String topic : topics) {
            TopicName topicName = TopicName.get((String)topic);
            String partitionedTopicName = topicName.getPartitionedTopicName();
            if (!topicName.isPartitioned()) {
                fullTopics.add(partitionedTopicName);
                partitionedTopics.remove(partitionedTopicName);
                continue;
            }
            if (fullTopics.contains(partitionedTopicName)) continue;
            List partitionIds = partitionedTopics.computeIfAbsent(partitionedTopicName, k -> new ArrayList());
            partitionIds.add(topicName.getPartitionIndex());
        }
        ImmutableList.Builder builder = ImmutableList.builder().addAll(fullTopics);
        for (Map.Entry topicSet : partitionedTopics.entrySet()) {
            String topicName = (String)topicSet.getKey();
            for (Integer partitionId : (List)topicSet.getValue()) {
                builder.add((Object)TopicNameUtils.topicNameWithPartition(topicName, partitionId));
            }
        }
        return builder.build();
    }

    public static boolean isInternal(String topic) {
        String topicName = TopicNameUtils.topicName(topic);
        TopicName topicInstance = TopicName.get((String)topicName);
        String localName = topicInstance.getLocalName();
        String namespace = topicInstance.getNamespace();
        return namespace.equals(NamespaceName.SYSTEM_NAMESPACE.toString()) || SLA_NAMESPACE_PATTERN.matcher(namespace).matches() || HEARTBEAT_NAMESPACE_PATTERN.matcher(namespace).matches() || HEARTBEAT_NAMESPACE_PATTERN_V2.matcher(namespace).matches() || EVENTS_TOPIC_NAMES.contains(localName) || topicName.startsWith(TRANSACTION_COORDINATOR_ASSIGN_PREFIX) || topicName.startsWith(TRANSACTION_COORDINATOR_LOG_PREFIX) || localName.endsWith(PENDING_ACK_STORE_SUFFIX) || localName.endsWith(PENDING_ACK_STORE_CURSOR_SUFFIX);
    }
}

