/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.ChunkMessageIdImpl;

@PublicEvolving
public final class CursorPosition
implements Serializable {
    private static final long serialVersionUID = -802405183307684549L;
    private final Type type;
    private final MessageId messageId;
    private final boolean include;
    private final Long timestamp;

    public CursorPosition(MessageId messageId, boolean include) {
        Preconditions.checkNotNull((Object)messageId, (String)"Message id couldn't be null.");
        this.type = Type.MESSAGE_ID;
        this.messageId = messageId;
        this.include = include;
        this.timestamp = null;
    }

    public CursorPosition(Long timestamp) {
        Preconditions.checkNotNull((Object)timestamp, (String)"Timestamp couldn't be null.");
        this.type = Type.TIMESTAMP;
        this.messageId = null;
        this.include = true;
        this.timestamp = timestamp;
    }

    @Internal
    public boolean createInitialPosition(PulsarAdmin pulsarAdmin, String topicName, String subscriptionName) throws PulsarAdminException {
        List subscriptions = pulsarAdmin.topics().getSubscriptions(topicName);
        if (!subscriptions.contains(subscriptionName)) {
            pulsarAdmin.topics().createSubscription(topicName, subscriptionName, MessageId.earliest);
            MessageId initialPosition = this.getMessageId(pulsarAdmin, topicName);
            pulsarAdmin.topics().resetCursor(topicName, subscriptionName, initialPosition, !this.include);
            return true;
        }
        return false;
    }

    @Internal
    public void seekPosition(PulsarAdmin pulsarAdmin, String topicName, String subscriptionName) throws PulsarAdminException {
        if (!this.createInitialPosition(pulsarAdmin, topicName, subscriptionName)) {
            MessageId initialPosition = this.getMessageId(pulsarAdmin, topicName);
            pulsarAdmin.topics().resetCursor(topicName, subscriptionName, initialPosition, !this.include);
        }
    }

    private MessageId getMessageId(PulsarAdmin pulsarAdmin, String topicName) throws PulsarAdminException {
        if (this.type == Type.TIMESTAMP) {
            return pulsarAdmin.topics().getMessageIdByTimestamp(topicName, this.timestamp.longValue());
        }
        if (this.messageId instanceof ChunkMessageIdImpl) {
            return ((ChunkMessageIdImpl)this.messageId).getFirstChunkMessageId();
        }
        return this.messageId;
    }

    public String toString() {
        if (this.type == Type.TIMESTAMP) {
            return "timestamp: " + this.timestamp;
        }
        return "message id: " + this.messageId + " include: " + this.include;
    }

    @Internal
    public static enum Type {
        TIMESTAMP,
        MESSAGE_ID;

    }
}

