/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.assigner;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SplitAssignerBase;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;

@Internal
class SharedSplitAssigner
extends SplitAssignerBase {
    public SharedSplitAssigner(StopCursor stopCursor, boolean enablePartitionDiscovery, SplitEnumeratorContext<PulsarPartitionSplit> context, PulsarSourceEnumState enumState) {
        super(stopCursor, enablePartitionDiscovery, context, enumState);
    }

    @Override
    public List<TopicPartition> registerTopicPartitions(Set<TopicPartition> fetchedPartitions) {
        ArrayList<TopicPartition> newPartitions = new ArrayList<TopicPartition>();
        for (TopicPartition partition : fetchedPartitions) {
            boolean shouldAssign = false;
            if (!this.appendedPartitions.contains(partition)) {
                this.appendedPartitions.add(partition);
                newPartitions.add(partition);
                shouldAssign = true;
            }
            if (!shouldAssign && this.initialized) continue;
            for (int i = 0; i < this.context.currentParallelism(); ++i) {
                PulsarPartitionSplit split = new PulsarPartitionSplit(partition, this.stopCursor);
                this.addSplitToPendingList(i, split);
            }
        }
        if (!this.initialized) {
            this.initialized = true;
        }
        return newPartitions;
    }

    @Override
    public void addSplitsBack(List<PulsarPartitionSplit> splits, int subtaskId) {
        if (splits.isEmpty()) {
            for (TopicPartition partition : this.appendedPartitions) {
                this.addSplitToPendingList(subtaskId, new PulsarPartitionSplit(partition, this.stopCursor));
            }
        } else {
            for (PulsarPartitionSplit split : splits) {
                this.addSplitToPendingList(subtaskId, split);
            }
        }
    }
}

