/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.serializer;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessage;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSchemaWrapper;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchemaWrapper;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.KeyValue;

@PublicEvolving
public interface PulsarSerializationSchema<IN>
extends Serializable {
    default public void open(SerializationSchema.InitializationContext initializationContext, PulsarSinkContext sinkContext, SinkConfiguration sinkConfiguration) throws Exception {
    }

    public PulsarMessage<?> serialize(IN var1, PulsarSinkContext var2);

    public static <T> PulsarSerializationSchema<T> flinkSchema(SerializationSchema<T> serializationSchema) {
        return new PulsarSerializationSchemaWrapper<T>(serializationSchema);
    }

    public static <T> PulsarSerializationSchema<T> pulsarSchema(Schema<T> schema) {
        PulsarSchema<T> pulsarSchema = new PulsarSchema<T>(schema);
        return new PulsarSchemaWrapper<T>(pulsarSchema);
    }

    public static <T> PulsarSerializationSchema<T> pulsarSchema(Schema<T> schema, Class<T> typeClass) {
        PulsarSchema<T> pulsarSchema = new PulsarSchema<T>(schema, typeClass);
        return new PulsarSchemaWrapper<T>(pulsarSchema);
    }

    public static <K, V> PulsarSerializationSchema<KeyValue<K, V>> pulsarSchema(Schema<KeyValue<K, V>> schema, Class<K> keyClass, Class<V> valueClass) {
        PulsarSchema pulsarSchema = new PulsarSchema(schema, keyClass, valueClass);
        return new PulsarSchemaWrapper<KeyValue<K, V>>(pulsarSchema);
    }
}

