/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.context;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.context.PulsarSinkContext;

@Internal
public class PulsarSinkContextImpl
implements PulsarSinkContext {
    private final int numberOfParallelSubtasks;
    private final int parallelInstanceId;
    private final ProcessingTimeService processingTimeService;
    private final boolean enableSchemaEvolution;

    public PulsarSinkContextImpl(Sink.InitContext initContext, SinkConfiguration sinkConfiguration) {
        this.parallelInstanceId = initContext.getSubtaskId();
        this.numberOfParallelSubtasks = initContext.getNumberOfParallelSubtasks();
        this.processingTimeService = initContext.getProcessingTimeService();
        this.enableSchemaEvolution = sinkConfiguration.isEnableSchemaEvolution();
    }

    @Override
    public int getParallelInstanceId() {
        return this.parallelInstanceId;
    }

    @Override
    public int getNumberOfParallelInstances() {
        return this.numberOfParallelSubtasks;
    }

    @Override
    public boolean isEnableSchemaEvolution() {
        return this.enableSchemaEvolution;
    }

    @Override
    public long processTime() {
        return this.processingTimeService.getCurrentProcessingTime();
    }
}

