/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Range;

@PublicEvolving
public class TopicRange
implements Serializable {
    private static final long serialVersionUID = 3176938692775594400L;
    public static final int RANGE_SIZE = 65536;
    public static final int MIN_RANGE = 0;
    public static final int MAX_RANGE = 65535;
    private final int start;
    private final int end;

    public TopicRange(int start, int end) {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (String)"Start range %s shouldn't below zero.", (Object[])new Object[]{start});
        Preconditions.checkArgument((end <= 65535 ? 1 : 0) != 0, (String)"End range %s shouldn't exceed 65535.", (Object[])new Object[]{end});
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"Range end must >= range start.");
        this.start = start;
        this.end = end;
    }

    public Range toPulsarRange() {
        return new Range(this.start, this.end);
    }

    public static TopicRange createFullRange() {
        return new TopicRange(0, 65535);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicRange that = (TopicRange)o;
        return this.start == that.start && this.end == that.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return this.getStart() + "-" + this.getEnd();
    }
}

