/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.config;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.SourceReaderOptions;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.connector.pulsar.source.PulsarSourceOptions;
import org.apache.flink.connector.pulsar.source.config.CursorVerification;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;

@PublicEvolving
public class SourceConfiguration
extends PulsarConfiguration {
    private static final long serialVersionUID = 8488507275800787580L;
    private final int messageQueueCapacity = this.getInteger(SourceReaderOptions.ELEMENT_QUEUE_CAPACITY);
    private final long partitionDiscoveryIntervalMs = (Long)this.get(PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS);
    private final boolean enableAutoAcknowledgeMessage = (Boolean)this.get(PulsarSourceOptions.PULSAR_ENABLE_AUTO_ACKNOWLEDGE_MESSAGE);
    private final long autoCommitCursorInterval = (Long)this.get(PulsarSourceOptions.PULSAR_AUTO_COMMIT_CURSOR_INTERVAL);
    private final long transactionTimeoutMillis = (Long)this.get(PulsarSourceOptions.PULSAR_READ_TRANSACTION_TIMEOUT);
    private final Duration maxFetchTime = this.get(PulsarSourceOptions.PULSAR_MAX_FETCH_TIME, Duration::ofMillis);
    private final int maxFetchRecords = (Integer)this.get(PulsarSourceOptions.PULSAR_MAX_FETCH_RECORDS);
    private final CursorVerification verifyInitialOffsets = (CursorVerification)((Object)this.get(PulsarSourceOptions.PULSAR_VERIFY_INITIAL_OFFSETS));
    private final String subscriptionName = (String)this.get(PulsarSourceOptions.PULSAR_SUBSCRIPTION_NAME);
    private final SubscriptionType subscriptionType = (SubscriptionType)this.get(PulsarSourceOptions.PULSAR_SUBSCRIPTION_TYPE);
    private final SubscriptionMode subscriptionMode = (SubscriptionMode)this.get(PulsarSourceOptions.PULSAR_SUBSCRIPTION_MODE);
    private final boolean allowKeySharedOutOfOrderDelivery = (Boolean)this.get(PulsarSourceOptions.PULSAR_ALLOW_KEY_SHARED_OUT_OF_ORDER_DELIVERY);

    public SourceConfiguration(Configuration configuration) {
        super(configuration);
    }

    public int getMessageQueueCapacity() {
        return this.messageQueueCapacity;
    }

    public boolean isEnablePartitionDiscovery() {
        return this.getPartitionDiscoveryIntervalMs() > 0L;
    }

    public long getPartitionDiscoveryIntervalMs() {
        return this.partitionDiscoveryIntervalMs;
    }

    public boolean isEnableAutoAcknowledgeMessage() {
        return this.enableAutoAcknowledgeMessage;
    }

    public long getAutoCommitCursorInterval() {
        return this.autoCommitCursorInterval;
    }

    public long getTransactionTimeoutMillis() {
        return this.transactionTimeoutMillis;
    }

    public Duration getMaxFetchTime() {
        return this.maxFetchTime;
    }

    public int getMaxFetchRecords() {
        return this.maxFetchRecords;
    }

    public CursorVerification getVerifyInitialOffsets() {
        return this.verifyInitialOffsets;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public boolean isAllowKeySharedOutOfOrderDelivery() {
        return this.allowKeySharedOutOfOrderDelivery;
    }

    public String getSubscriptionDesc() {
        return this.getSubscriptionName() + "(" + this.getSubscriptionType() + "," + this.getSubscriptionMode() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceConfiguration that = (SourceConfiguration)((Object)o);
        return this.partitionDiscoveryIntervalMs == that.partitionDiscoveryIntervalMs && this.enableAutoAcknowledgeMessage == that.enableAutoAcknowledgeMessage && this.autoCommitCursorInterval == that.autoCommitCursorInterval && this.transactionTimeoutMillis == that.transactionTimeoutMillis && this.maxFetchRecords == that.maxFetchRecords && Objects.equals(this.maxFetchTime, that.maxFetchTime) && this.verifyInitialOffsets == that.verifyInitialOffsets && Objects.equals(this.subscriptionName, that.subscriptionName) && this.subscriptionType == that.subscriptionType && this.subscriptionMode == that.subscriptionMode && this.allowKeySharedOutOfOrderDelivery == that.allowKeySharedOutOfOrderDelivery;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.partitionDiscoveryIntervalMs, this.enableAutoAcknowledgeMessage, this.autoCommitCursorInterval, this.transactionTimeoutMillis, this.maxFetchTime, this.maxFetchRecords, this.verifyInitialOffsets, this.subscriptionName, this.subscriptionType, this.subscriptionMode, this.allowKeySharedOutOfOrderDelivery});
    }
}

