/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema.factories;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchema;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaTypeInformation;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaUtils;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class KeyValueSchemaFactory<K, V>
implements PulsarSchemaFactory<KeyValue<K, V>> {
    @Override
    public SchemaType type() {
        return SchemaType.KEY_VALUE;
    }

    @Override
    public Schema<KeyValue<K, V>> createSchema(SchemaInfo info) {
        KeyValue kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)info);
        Schema keySchema = PulsarSchemaUtils.createSchema((SchemaInfo)kvSchemaInfo.getKey());
        Schema valueSchema = PulsarSchemaUtils.createSchema((SchemaInfo)kvSchemaInfo.getValue());
        KeyValueEncodingType encodingType = KeyValueSchemaInfo.decodeKeyValueEncodingType((SchemaInfo)info);
        Schema schema = KeyValueSchemaImpl.of(keySchema, valueSchema, (KeyValueEncodingType)encodingType);
        SchemaInfo schemaInfo = schema.getSchemaInfo();
        Map properties = schemaInfo.getProperties();
        properties.put("INTERNAL.pulsar.schema.type.class.name", KeyValue.class.getName());
        return schema;
    }

    @Override
    public TypeInformation<KeyValue<K, V>> createTypeInfo(SchemaInfo info) {
        KeyValue kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)info);
        Schema keySchema = PulsarSchemaUtils.createSchema((SchemaInfo)kvSchemaInfo.getKey());
        Class keyClass = PulsarSchemaUtils.decodeClassInfo(keySchema.getSchemaInfo());
        Schema valueSchema = PulsarSchemaUtils.createSchema((SchemaInfo)kvSchemaInfo.getValue());
        Class valueClass = PulsarSchemaUtils.decodeClassInfo(valueSchema.getSchemaInfo());
        Schema<KeyValue<K, V>> schema = this.createSchema(info);
        PulsarSchema pulsarSchema = new PulsarSchema(schema, keyClass, valueClass);
        return new PulsarSchemaTypeInformation<KeyValue<K, V>>(pulsarSchema);
    }
}

