/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.common.naming.TopicName;

@Internal
public final class TopicNameUtils {
    private TopicNameUtils() {
    }

    public static String topicName(String topic) {
        return TopicName.get((String)topic).getPartitionedTopicName();
    }

    public static String topicNameWithPartition(String topic, int partitionId) {
        Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (String)"Illegal partition id %s", (Object[])new Object[]{partitionId});
        return TopicName.get((String)topic).getPartition(partitionId).toString();
    }

    public static String topicNameWithoutPartition(String topic) {
        return TopicName.get((String)topic).toString();
    }

    public static boolean isPartition(String topic) {
        return TopicName.get((String)topic).isPartitioned();
    }

    public static List<String> distinctTopics(List<String> topics) {
        HashSet<String> fullTopics = new HashSet<String>();
        HashMap<String, List> partitionedTopics = new HashMap<String, List>();
        for (String topic : topics) {
            TopicName topicName = TopicName.get((String)topic);
            String partitionedTopicName = topicName.getPartitionedTopicName();
            if (!topicName.isPartitioned()) {
                fullTopics.add(partitionedTopicName);
                partitionedTopics.remove(partitionedTopicName);
                continue;
            }
            if (fullTopics.contains(partitionedTopicName)) continue;
            List partitionIds = partitionedTopics.computeIfAbsent(partitionedTopicName, k -> new ArrayList());
            partitionIds.add(topicName.getPartitionIndex());
        }
        ImmutableList.Builder builder = ImmutableList.builder().addAll(fullTopics);
        for (Map.Entry topicSet : partitionedTopics.entrySet()) {
            String topicName = (String)topicSet.getKey();
            for (Integer partitionId : (List)topicSet.getValue()) {
                builder.add((Object)TopicNameUtils.topicNameWithPartition(topicName, partitionId));
            }
        }
        return builder.build();
    }
}

