/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.stop;

import org.apache.flink.connector.pulsar.source.enumerator.cursor.MessageIdUtils;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;

public class MessageIdStopCursor
implements StopCursor {
    private static final long serialVersionUID = -3990454110809274542L;
    private final MessageId messageId;
    private final boolean inclusive;

    public MessageIdStopCursor(MessageId messageId, boolean inclusive) {
        MessageIdImpl idImpl = MessageIdUtils.unwrapMessageId(messageId);
        Preconditions.checkArgument((!MessageId.earliest.equals(idImpl) ? 1 : 0) != 0, (Object)"MessageId.earliest is not supported.");
        Preconditions.checkArgument((!MessageId.latest.equals(idImpl) ? 1 : 0) != 0, (Object)"MessageId.latest is not supported, use LatestMessageStopCursor instead.");
        this.messageId = idImpl;
        this.inclusive = inclusive;
    }

    @Override
    public StopCursor.StopCondition shouldStop(Message<?> message) {
        MessageId current = message.getMessageId();
        return StopCursor.StopCondition.compare(this.messageId, current, this.inclusive);
    }
}

