/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.EventTimestampStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.LatestMessageStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.MessageIdStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.NeverStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.PublishTimestampStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;

@FunctionalInterface
@PublicEvolving
public interface StopCursor
extends Serializable {
    default public void open(PulsarAdmin admin, TopicPartition partition) {
    }

    public StopCondition shouldStop(Message<?> var1);

    public static StopCursor defaultStopCursor() {
        return StopCursor.never();
    }

    public static StopCursor never() {
        return new NeverStopCursor();
    }

    public static StopCursor latest() {
        return new LatestMessageStopCursor(true);
    }

    public static StopCursor atMessageId(MessageId messageId) {
        if (MessageId.latest.equals(messageId)) {
            return new LatestMessageStopCursor(false);
        }
        return new MessageIdStopCursor(messageId, false);
    }

    public static StopCursor afterMessageId(MessageId messageId) {
        if (MessageId.latest.equals(messageId)) {
            return new LatestMessageStopCursor(true);
        }
        return new MessageIdStopCursor(messageId, true);
    }

    public static StopCursor atEventTime(long timestamp) {
        return new EventTimestampStopCursor(timestamp, false);
    }

    public static StopCursor afterEventTime(long timestamp) {
        return new EventTimestampStopCursor(timestamp, true);
    }

    public static StopCursor atPublishTime(long timestamp) {
        return new PublishTimestampStopCursor(timestamp, false);
    }

    public static StopCursor afterPublishTime(long timestamp) {
        return new PublishTimestampStopCursor(timestamp, true);
    }

    @PublicEvolving
    public static enum StopCondition {
        CONTINUE,
        EXACTLY,
        TERMINATE;


        public static StopCondition compare(MessageId desired, MessageId current, boolean inclusive) {
            if (current.compareTo((Object)desired) < 0) {
                return CONTINUE;
            }
            if (current.compareTo((Object)desired) == 0) {
                return inclusive ? EXACTLY : TERMINATE;
            }
            return TERMINATE;
        }

        public static StopCondition compare(long desired, long current, boolean inclusive) {
            if (current < desired) {
                return CONTINUE;
            }
            if (current == desired) {
                return inclusive ? EXACTLY : TERMINATE;
            }
            return TERMINATE;
        }
    }
}

