/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;

@Internal
public final class MessageIdUtils {
    private MessageIdUtils() {
    }

    public static MessageId nextMessageId(MessageId messageId) {
        MessageIdImpl idImpl = MessageIdUtils.unwrapMessageId(messageId);
        if (idImpl.getEntryId() < 0L) {
            return MessageIdUtils.newMessageId(idImpl.getLedgerId(), 0L, idImpl.getPartitionIndex());
        }
        return MessageIdUtils.newMessageId(idImpl.getLedgerId(), idImpl.getEntryId() + 1L, idImpl.getPartitionIndex());
    }

    public static MessageIdImpl unwrapMessageId(MessageId messageId) {
        MessageIdImpl idImpl = MessageIdImpl.convertToMessageIdImpl((MessageId)messageId);
        if (idImpl instanceof BatchMessageIdImpl) {
            int batchSize = ((BatchMessageIdImpl)idImpl).getBatchSize();
            Preconditions.checkArgument((batchSize == 1 ? 1 : 0) != 0, (Object)"We only support normal message id currently.");
        }
        return idImpl;
    }

    public static MessageId newMessageId(long ledgerId, long entryId, int partitionIndex) {
        return new MessageIdImpl(ledgerId, entryId, partitionIndex);
    }
}

