/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.assigner;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.NonSharedSplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SharedSplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.pulsar.client.api.SubscriptionType;

@Internal
public final class SplitAssignerFactory {
    private SplitAssignerFactory() {
    }

    public static SplitAssigner create(StopCursor stopCursor, SourceConfiguration sourceConfiguration) {
        return SplitAssignerFactory.create(stopCursor, sourceConfiguration, PulsarSourceEnumState.initialState());
    }

    public static SplitAssigner create(StopCursor stopCursor, SourceConfiguration sourceConfiguration, PulsarSourceEnumState sourceEnumState) {
        SubscriptionType subscriptionType = sourceConfiguration.getSubscriptionType();
        if (subscriptionType == SubscriptionType.Exclusive || subscriptionType == SubscriptionType.Failover || subscriptionType == SubscriptionType.Key_Shared) {
            return new NonSharedSplitAssigner(stopCursor, sourceConfiguration, sourceEnumState);
        }
        if (subscriptionType == SubscriptionType.Shared) {
            return new SharedSplitAssigner(stopCursor, sourceConfiguration, sourceEnumState);
        }
        throw new IllegalArgumentException("We don't support this subscription type: " + subscriptionType);
    }
}

