/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.fetcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcher;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcherManager;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.connector.pulsar.source.reader.message.PulsarMessage;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;

@Internal
public abstract class PulsarFetcherManagerBase<T>
extends SplitFetcherManager<PulsarMessage<T>, PulsarPartitionSplit> {
    private final Map<String, Integer> splitFetcherMapping = new HashMap<String, Integer>();
    private final Map<Integer, Boolean> fetcherStatus = new HashMap<Integer, Boolean>();

    protected PulsarFetcherManagerBase(FutureCompletingBlockingQueue<RecordsWithSplitIds<PulsarMessage<T>>> elementsQueue, Supplier<SplitReader<PulsarMessage<T>, PulsarPartitionSplit>> splitReaderSupplier) {
        super(elementsQueue, splitReaderSupplier);
    }

    public void addSplits(List<PulsarPartitionSplit> splitsToAdd) {
        for (PulsarPartitionSplit split : splitsToAdd) {
            SplitFetcher<PulsarMessage<T>, PulsarPartitionSplit> fetcher = this.getOrCreateFetcher(split.splitId());
            fetcher.addSplits(Collections.singletonList(split));
            this.startFetcher(fetcher);
        }
    }

    protected void startFetcher(SplitFetcher<PulsarMessage<T>, PulsarPartitionSplit> fetcher) {
        if (this.fetcherStatus.get(fetcher.fetcherId()) != Boolean.TRUE) {
            this.fetcherStatus.put(fetcher.fetcherId(), true);
            super.startFetcher(fetcher);
        }
    }

    protected SplitFetcher<PulsarMessage<T>, PulsarPartitionSplit> getOrCreateFetcher(String splitId) {
        SplitFetcher fetcher;
        Integer fetcherId = this.splitFetcherMapping.get(splitId);
        if (fetcherId == null) {
            fetcher = this.createSplitFetcher();
        } else {
            fetcher = (SplitFetcher)this.fetchers.get(fetcherId);
            if (fetcher == null) {
                this.fetcherStatus.remove(fetcherId);
                fetcher = this.createSplitFetcher();
            }
        }
        this.splitFetcherMapping.put(splitId, fetcher.fetcherId());
        return fetcher;
    }
}

