/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.PulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;

public abstract class BasePulsarSubscriber
implements PulsarSubscriber {
    private static final long serialVersionUID = 2053021503331058888L;

    protected TopicMetadata queryTopicMetadata(PulsarAdmin pulsarAdmin, String topicName) {
        String completeTopicName = TopicNameUtils.topicName(topicName);
        try {
            PartitionedTopicMetadata metadata = pulsarAdmin.topics().getPartitionedTopicMetadata(completeTopicName);
            return new TopicMetadata(topicName, metadata.partitions);
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw new IllegalStateException(e);
        }
    }

    protected List<TopicPartition> toTopicPartitions(TopicMetadata metadata, List<TopicRange> ranges) {
        if (!metadata.isPartitioned()) {
            return ranges.stream().map(range -> new TopicPartition(metadata.getName(), -1, (TopicRange)range)).collect(Collectors.toList());
        }
        return IntStream.range(0, metadata.getPartitionSize()).boxed().flatMap(partitionId -> ranges.stream().map(range -> new TopicPartition(metadata.getName(), (int)partitionId, (TopicRange)range))).collect(Collectors.toList());
    }
}

