/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.stop;

import org.apache.flink.connector.pulsar.common.utils.PulsarExceptionUtils;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;

public class LatestMessageStopCursor
implements StopCursor {
    private static final long serialVersionUID = 1702059838323965723L;
    private MessageId messageId;

    @Override
    public void open(PulsarAdmin admin, TopicPartition partition) {
        if (this.messageId == null) {
            String topic = partition.getFullTopicName();
            this.messageId = (MessageId)PulsarExceptionUtils.sneakyAdmin(() -> admin.topics().getLastMessageId(topic));
        }
    }

    @Override
    public boolean shouldStop(Message<?> message) {
        MessageId id = message.getMessageId();
        return id.compareTo((Object)this.messageId) >= 0;
    }
}

