/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.start;

import org.apache.flink.connector.pulsar.source.enumerator.cursor.CursorPosition;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StartCursor;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;

public class MessageIdStartCursor
implements StartCursor {
    private static final long serialVersionUID = -8057345435887170111L;
    private final MessageId messageId;

    public MessageIdStartCursor(MessageId messageId, boolean inclusive) {
        if (inclusive) {
            this.messageId = messageId;
        } else {
            Preconditions.checkState((boolean)(messageId instanceof MessageIdImpl), (Object)"We only support normal message id and batch message id.");
            MessageIdImpl id = (MessageIdImpl)messageId;
            this.messageId = MessageId.earliest.equals(messageId) || MessageId.latest.equals(messageId) ? messageId : new MessageIdImpl(id.getLedgerId(), id.getEntryId() + 1L, id.getPartitionIndex());
        }
    }

    @Override
    public CursorPosition position(String topic, int partitionId) {
        return new CursorPosition(this.messageId);
    }
}

