/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.EventTimestampStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.LatestMessageStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.MessageIdStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.NeverStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.stop.PublishTimestampStopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;

@FunctionalInterface
@PublicEvolving
public interface StopCursor
extends Serializable {
    default public void open(PulsarAdmin admin, TopicPartition partition) {
    }

    public boolean shouldStop(Message<?> var1);

    public static StopCursor defaultStopCursor() {
        return StopCursor.never();
    }

    public static StopCursor never() {
        return new NeverStopCursor();
    }

    public static StopCursor latest() {
        return new LatestMessageStopCursor();
    }

    public static StopCursor atMessageId(MessageId messageId) {
        return new MessageIdStopCursor(messageId);
    }

    public static StopCursor afterMessageId(MessageId messageId) {
        return new MessageIdStopCursor(messageId, false);
    }

    @Deprecated
    public static StopCursor atEventTime(long timestamp) {
        return new EventTimestampStopCursor(timestamp);
    }

    public static StopCursor atPublishTime(long timestamp) {
        return new PublishTimestampStopCursor(timestamp);
    }
}

