/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;

@PublicEvolving
public final class CursorPosition
implements Serializable {
    private static final long serialVersionUID = -802405183307684549L;
    private final Type type;
    private final MessageId messageId;
    private final Long timestamp;

    public CursorPosition(@Nullable MessageId messageId) {
        this.type = Type.MESSAGE_ID;
        this.messageId = messageId;
        this.timestamp = null;
    }

    public CursorPosition(@Nullable Long timestamp) {
        this.type = Type.TIMESTAMP;
        this.messageId = null;
        this.timestamp = timestamp;
    }

    @VisibleForTesting
    public MessageId getMessageId() {
        return this.messageId;
    }

    public void seekPosition(Consumer<?> consumer) throws PulsarClientException {
        if (this.type == Type.MESSAGE_ID) {
            consumer.seek(this.messageId);
        } else if (this.timestamp != null) {
            consumer.seek(this.timestamp.longValue());
        } else {
            consumer.seek(System.currentTimeMillis());
        }
    }

    public String toString() {
        if (this.type == Type.TIMESTAMP) {
            return "timestamp: " + this.timestamp;
        }
        return "message id: " + this.messageId;
    }

    public static enum Type {
        TIMESTAMP,
        MESSAGE_ID;

    }
}

