/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.writer.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.sink.writer.message.PulsarMessage;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;

@PublicEvolving
public class PulsarMessageBuilder<T> {
    private byte[] orderingKey;
    private String key;
    private long eventTime;
    Schema<T> schema;
    private T value;
    private Map<String, String> properties = new HashMap<String, String>();
    private Long sequenceId;
    private List<String> replicationClusters;
    private boolean disableReplication = false;

    public PulsarMessageBuilder<T> orderingKey(byte[] orderingKey) {
        this.orderingKey = (byte[])Preconditions.checkNotNull((Object)orderingKey);
        return this;
    }

    public PulsarMessageBuilder<T> key(String key) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        return null;
    }

    public PulsarMessageBuilder<T> eventTime(long eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public PulsarMessageBuilder<T> value(Schema<T> schema, T value) {
        this.schema = (Schema)Preconditions.checkNotNull(schema);
        this.value = value;
        return this;
    }

    public PulsarMessageBuilder<T> property(String key, String value) {
        this.properties.put((String)Preconditions.checkNotNull((Object)key), (String)Preconditions.checkNotNull((Object)value));
        return this;
    }

    public PulsarMessageBuilder<T> properties(Map<String, String> properties) {
        this.properties.putAll((Map)Preconditions.checkNotNull(properties));
        return this;
    }

    public PulsarMessageBuilder<T> sequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
        return this;
    }

    public PulsarMessageBuilder<T> replicationClusters(List<String> replicationClusters) {
        this.replicationClusters = (List)Preconditions.checkNotNull(replicationClusters);
        return this;
    }

    public PulsarMessageBuilder<T> disableReplication() {
        this.disableReplication = true;
        return this;
    }

    public PulsarMessage<T> build() {
        Preconditions.checkNotNull(this.schema, (String)"Schema should be provided.");
        return new PulsarMessage<T>(this.orderingKey, this.key, this.eventTime, this.schema, this.value, this.properties, this.sequenceId, this.replicationClusters, this.disableReplication);
    }
}

