/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.config;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.BlockElement;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.pulsar.client.api.ProxyProtocol;

@ConfigGroups(groups={@ConfigGroup(name="PulsarClient", keyPrefix="pulsar.client."), @ConfigGroup(name="PulsarAdmin", keyPrefix="pulsar.admin.")})
@PublicEvolving
public final class PulsarOptions {
    public static final String CLIENT_CONFIG_PREFIX = "pulsar.client.";
    public static final String ADMIN_CONFIG_PREFIX = "pulsar.admin.";
    public static final ConfigOption<String> PULSAR_SERVICE_URL = ConfigOptions.key((String)"pulsar.client.serviceUrl").stringType().noDefaultValue().withDescription(Description.builder().text("Service URL provider for Pulsar service.").linebreak().text("To connect to Pulsar using client libraries, you need to specify a Pulsar protocol URL.").linebreak().text("You can assign Pulsar protocol URLs to specific clusters and use the Pulsar scheme.").linebreak().list(new InlineElement[]{TextElement.text((String)"This is an example of %s: %s.", (InlineElement[])new InlineElement[]{TextElement.code((String)"localhost"), TextElement.code((String)"pulsar://localhost:6650")}), TextElement.text((String)"If you have multiple brokers, the URL is as: %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar://localhost:6550,localhost:6651,localhost:6652")}), TextElement.text((String)"A URL for a production Pulsar cluster is as: %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar://pulsar.us-west.example.com:6650")}), TextElement.text((String)"If you use TLS authentication, the URL is as %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"pulsar+ssl://pulsar.us-west.example.com:6651")})}).build());
    public static final ConfigOption<String> PULSAR_AUTH_PLUGIN_CLASS_NAME = ConfigOptions.key((String)"pulsar.client.authPluginClassName").stringType().noDefaultValue().withDescription("Name of the authentication plugin.");
    public static final ConfigOption<String> PULSAR_AUTH_PARAMS = ConfigOptions.key((String)"pulsar.client.authParams").stringType().noDefaultValue().withDescription(Description.builder().text("Parameters for the authentication plugin.").linebreak().linebreak().text("Example:").linebreak().add((BlockElement)TextElement.code((String)"key1:val1,key2:val2")).build());
    public static final ConfigOption<Map<String, String>> PULSAR_AUTH_PARAM_MAP = ConfigOptions.key((String)"pulsar.client.authParamMap").mapType().noDefaultValue().withDescription("Parameters for the authentication plugin.");
    public static final ConfigOption<Integer> PULSAR_OPERATION_TIMEOUT_MS = ConfigOptions.key((String)"pulsar.client.operationTimeoutMs").intType().defaultValue((Object)30000).withDescription(Description.builder().text("Operation timeout (in ms).").text(" Operations such as creating producers, subscribing or unsubscribing topics are retried during this interval.").text(" If the operation is not completed during this interval, the operation will be marked as failed.").build());
    public static final ConfigOption<Long> PULSAR_STATS_INTERVAL_SECONDS = ConfigOptions.key((String)"pulsar.client.statsIntervalSeconds").longType().defaultValue((Object)60L).withDescription(Description.builder().text("Interval between each stats info.").linebreak().list(new InlineElement[]{TextElement.text((String)"Stats is activated with positive %s", (InlineElement[])new InlineElement[]{TextElement.code((String)"statsInterval")}), TextElement.text((String)"Set %s to 1 second at least.", (InlineElement[])new InlineElement[]{TextElement.code((String)"statsIntervalSeconds")})}).build());
    public static final ConfigOption<Integer> PULSAR_NUM_IO_THREADS = ConfigOptions.key((String)"pulsar.client.numIoThreads").intType().defaultValue((Object)1).withDescription("The number of threads used for handling connections to brokers.");
    public static final ConfigOption<Integer> PULSAR_NUM_LISTENER_THREADS = ConfigOptions.key((String)"pulsar.client.numListenerThreads").intType().defaultValue((Object)1).withDescription(Description.builder().text("The number of threads used for handling message listeners.").text(" The listener thread pool is shared across all the consumers and readers that are using a %s model to get messages.", new InlineElement[]{TextElement.code((String)"listener")}).text(" For a given consumer, the listener is always invoked from the same thread to ensure ordering.").build());
    public static final ConfigOption<Integer> PULSAR_CONNECTIONS_PER_BROKER = ConfigOptions.key((String)"pulsar.client.connectionsPerBroker").intType().defaultValue((Object)1).withDescription(Description.builder().text("The maximum number of connections that the client library will open to a single broker.").linebreak().text(" By default, the connection pool will use a single connection for all the producers and consumers.").text(" Increasing this parameter may improve throughput when using many producers over a high latency connection.").build());
    public static final ConfigOption<Boolean> PULSAR_USE_TCP_NO_DELAY = ConfigOptions.key((String)"pulsar.client.useTcpNoDelay").booleanType().defaultValue((Object)true).withDescription(Description.builder().text("Whether to use the TCP no-delay flag on the connection to disable Nagle algorithm.").linebreak().text("No-delay features ensures that packets are sent out on the network as soon as possible,").text(" and it is critical to achieve low latency publishes.").text(" On the other hand, sending out a huge number of small packets might limit the overall throughput.").text(" Therefore, if latency is not a concern, it is recommended to set this option to %s.", new InlineElement[]{TextElement.code((String)"false")}).linebreak().text("By default, it is set to %s.", new InlineElement[]{TextElement.code((String)"true")}).build());
    public static final ConfigOption<String> PULSAR_TLS_TRUST_CERTS_FILE_PATH = ConfigOptions.key((String)"pulsar.client.tlsTrustCertsFilePath").stringType().defaultValue((Object)"").withDescription("Path to the trusted TLS certificate file.");
    public static final ConfigOption<Boolean> PULSAR_TLS_ALLOW_INSECURE_CONNECTION = ConfigOptions.key((String)"pulsar.client.tlsAllowInsecureConnection").booleanType().defaultValue((Object)false).withDescription("Whether the Pulsar client accepts untrusted TLS certificate from the broker.");
    public static final ConfigOption<Boolean> PULSAR_TLS_HOSTNAME_VERIFICATION_ENABLE = ConfigOptions.key((String)"pulsar.client.tlsHostnameVerificationEnable").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("Whether to enable TLS hostname verification.").text(" It allows to validate hostname verification when a client connects to the broker over TLS.").text(" It validates incoming x509 certificate and matches provided hostname (CN/SAN) with the expected broker's host name.").text(" It follows RFC 2818, 3.1. Server Identity hostname verification.").build());
    public static final ConfigOption<Integer> PULSAR_CONCURRENT_LOOKUP_REQUEST = ConfigOptions.key((String)"pulsar.client.concurrentLookupRequest").intType().defaultValue((Object)5000).withDescription(Description.builder().text("The number of concurrent lookup requests allowed to send on each broker connection to prevent overload on the broker.").text(" It should be configured with a higher value only in case of it requires to produce or subscribe on thousands of topic using a created %s", new InlineElement[]{TextElement.code((String)"PulsarClient")}).build());
    public static final ConfigOption<Integer> PULSAR_MAX_LOOKUP_REQUEST = ConfigOptions.key((String)"pulsar.client.maxLookupRequest").intType().defaultValue((Object)50000).withDescription(Description.builder().text("The maximum number of lookup requests allowed on each broker connection to prevent overload on the broker.").text(" It should be greater than %s.", new InlineElement[]{TextElement.code((String)"pulsar.client.concurrentLookupRequest")}).text(" Requests that inside %s are already sent to broker,", new InlineElement[]{TextElement.code((String)"pulsar.client.concurrentLookupRequest")}).text(" and requests beyond %s and under %s will wait in each client cnx.", new InlineElement[]{TextElement.code((String)"pulsar.client.concurrentLookupRequest"), TextElement.code((String)"maxLookupRequests")}).build());
    public static final ConfigOption<Integer> PULSAR_MAX_LOOKUP_REDIRECTS = ConfigOptions.key((String)"pulsar.client.maxLookupRedirects").intType().defaultValue((Object)20).withDescription("The maximum number of times a lookup-request redirections to a broker.");
    public static final ConfigOption<Integer> PULSAR_MAX_NUMBER_OF_REJECTED_REQUEST_PER_CONNECTION = ConfigOptions.key((String)"pulsar.client.maxNumberOfRejectedRequestPerConnection").intType().defaultValue((Object)50).withDescription(Description.builder().text("The maximum number of rejected requests of a broker in a certain period (30s) after the current connection is closed").text(" and the client creates a new connection to connect to a different broker.").build());
    public static final ConfigOption<Integer> PULSAR_KEEP_ALIVE_INTERVAL_SECONDS = ConfigOptions.key((String)"pulsar.client.keepAliveIntervalSeconds").intType().defaultValue((Object)30).withDescription("Interval (in seconds) for keeping connection between the Pulsar client and broker alive.");
    public static final ConfigOption<Integer> PULSAR_CONNECTION_TIMEOUT_MS = ConfigOptions.key((String)"pulsar.client.connectionTimeoutMs").intType().defaultValue((Object)10000).withDescription(Description.builder().text("Duration (in ms) of waiting for a connection to a broker to be established.").linebreak().text("If the duration passes without a response from a broker, the connection attempt is dropped.").build());
    public static final ConfigOption<Integer> PULSAR_REQUEST_TIMEOUT_MS = ConfigOptions.key((String)"pulsar.client.requestTimeoutMs").intType().defaultValue((Object)60000).withDescription("Maximum duration (in ms) for completing a request. This config option is not supported before Pulsar 2.8.1");
    public static final ConfigOption<Long> PULSAR_INITIAL_BACKOFF_INTERVAL_NANOS = ConfigOptions.key((String)"pulsar.client.initialBackoffIntervalNanos").longType().defaultValue((Object)TimeUnit.MILLISECONDS.toNanos(100L)).withDescription("Default duration (in nanoseconds) for a backoff interval.");
    public static final ConfigOption<Long> PULSAR_MAX_BACKOFF_INTERVAL_NANOS = ConfigOptions.key((String)"pulsar.client.maxBackoffIntervalNanos").longType().defaultValue((Object)TimeUnit.SECONDS.toNanos(60L)).withDescription("The maximum duration (in nanoseconds) for a backoff interval.");
    public static final ConfigOption<Boolean> PULSAR_ENABLE_BUSY_WAIT = ConfigOptions.key((String)"pulsar.client.enableBusyWait").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("Option to enable busy-wait settings.").linebreak().text("This option will enable spin-waiting on executors and IO threads in order to reduce latency during context switches.").text(" The spinning will consume 100% CPU even when the broker is not doing any work.").text(" It is recommended to reduce the number of IO threads and BookKeeper client threads to only have fewer CPU cores busy.").build());
    public static final ConfigOption<String> PULSAR_LISTENER_NAME = ConfigOptions.key((String)"pulsar.client.listenerName").stringType().noDefaultValue().withDescription(Description.builder().text("Configure the %s that the broker will return the corresponding %s.", new InlineElement[]{TextElement.code((String)"listenerName"), TextElement.code((String)"advertisedListener")}).build());
    public static final ConfigOption<Boolean> PULSAR_USE_KEY_STORE_TLS = ConfigOptions.key((String)"pulsar.client.useKeyStoreTls").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If TLS is enabled, whether use the KeyStore type as the TLS configuration parameter.").text(" If it is set to %s, it means to use the default pem type configuration.", new InlineElement[]{TextElement.code((String)"false")}).build());
    public static final ConfigOption<String> PULSAR_SSL_PROVIDER = ConfigOptions.key((String)"pulsar.client.sslProvider").stringType().noDefaultValue().withDescription(Description.builder().text("The name of the security provider used for SSL connections.").text(" The default value is the default security provider of the JVM.").build());
    public static final ConfigOption<String> PULSAR_TLS_TRUST_STORE_TYPE = ConfigOptions.key((String)"pulsar.client.tlsTrustStoreType").stringType().defaultValue((Object)"JKS").withDescription("The file format of the trust store file.");
    public static final ConfigOption<String> PULSAR_TLS_TRUST_STORE_PATH = ConfigOptions.key((String)"pulsar.client.tlsTrustStorePath").stringType().noDefaultValue().withDescription("The location of the trust store file.");
    public static final ConfigOption<String> PULSAR_TLS_TRUST_STORE_PASSWORD = ConfigOptions.key((String)"pulsar.client.tlsTrustStorePassword").stringType().noDefaultValue().withDescription("The store password for the key store file.");
    public static final ConfigOption<List<String>> PULSAR_TLS_CIPHERS = ConfigOptions.key((String)"pulsar.client.tlsCiphers").stringType().asList().defaultValues((Object[])new String[0]).withDescription(Description.builder().text("A list of cipher suites.").text(" This is a named combination of authentication, encryption,").text(" MAC and the key exchange algorithm used to negotiate the security settings for a network connection using the TLS or SSL network protocol.").text(" By default all the available cipher suites are supported.").build());
    public static final ConfigOption<List<String>> PULSAR_TLS_PROTOCOLS = ConfigOptions.key((String)"pulsar.client.tlsProtocols").stringType().asList().defaultValues((Object[])new String[0]).withDescription(Description.builder().text("The SSL protocol used to generate the SSLContext.").text(" By default, it is set TLS, which is fine for most cases.").text(" Allowed values in recent JVMs are TLS, TLSv1.3, TLSv1.2 and TLSv1.1.").build());
    public static final ConfigOption<Long> PULSAR_MEMORY_LIMIT_BYTES = ConfigOptions.key((String)"pulsar.client.memoryLimitBytes").longType().defaultValue((Object)0L).withDescription(Description.builder().text("The limit (in bytes) on the amount of direct memory that will be allocated by this client instance.").linebreak().text("Note: at this moment this is only limiting the memory for producers.").text(" Setting this to %s will disable the limit.", new InlineElement[]{TextElement.code((String)"0")}).build());
    public static final ConfigOption<String> PULSAR_PROXY_SERVICE_URL = ConfigOptions.key((String)"pulsar.client.proxyServiceUrl").stringType().noDefaultValue().withDescription(Description.builder().text("Proxy-service URL when a client connects to the broker via the proxy.").text(" The client can choose the type of proxy-routing.").build());
    public static final ConfigOption<ProxyProtocol> PULSAR_PROXY_PROTOCOL = ConfigOptions.key((String)"pulsar.client.proxyProtocol").enumType(ProxyProtocol.class).defaultValue((Object)ProxyProtocol.SNI).withDescription(Description.builder().text("Protocol type to determine the type of proxy routing when a client connects to the proxy using %s.", new InlineElement[]{TextElement.code((String)"pulsar.client.proxyServiceUrl")}).build());
    public static final ConfigOption<Boolean> PULSAR_ENABLE_TRANSACTION = ConfigOptions.key((String)"pulsar.client.enableTransaction").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("If transaction is enabled, start the %s with %s.", new InlineElement[]{TextElement.code((String)"transactionCoordinatorClient"), TextElement.code((String)"PulsarClient")}).build());
    public static final ConfigOption<String> PULSAR_ADMIN_URL = ConfigOptions.key((String)"pulsar.admin.adminUrl").stringType().noDefaultValue().withDescription(Description.builder().text("The Pulsar service HTTP URL for the admin endpoint. For example, %s, or %s for TLS.", new InlineElement[]{TextElement.code((String)"http://my-broker.example.com:8080"), TextElement.code((String)"https://my-broker.example.com:8443")}).build());
    public static final ConfigOption<Integer> PULSAR_CONNECT_TIMEOUT = ConfigOptions.key((String)"pulsar.admin.connectTimeout").intType().defaultValue((Object)60000).withDescription("The connection time out (in ms) for the PulsarAdmin client.");
    public static final ConfigOption<Integer> PULSAR_READ_TIMEOUT = ConfigOptions.key((String)"pulsar.admin.readTimeout").intType().defaultValue((Object)60000).withDescription("The server response read timeout (in ms) for the PulsarAdmin client for any request.");
    public static final ConfigOption<Integer> PULSAR_REQUEST_TIMEOUT = ConfigOptions.key((String)"pulsar.admin.requestTimeout").intType().defaultValue((Object)300000).withDescription("The server request timeout (in ms) for the PulsarAdmin client for any request.");
    public static final ConfigOption<Integer> PULSAR_AUTO_CERT_REFRESH_TIME = ConfigOptions.key((String)"pulsar.admin.autoCertRefreshTime").intType().defaultValue((Object)300000).withDescription("The auto cert refresh time (in ms) if Pulsar admin supports TLS authentication.");

    private PulsarOptions() {
    }
}

