/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.config;

import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.common.utils.PulsarExceptionUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SizeUnit;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;

@Internal
public final class PulsarClientFactory {
    private PulsarClientFactory() {
    }

    public static PulsarClient createClient(PulsarConfiguration configuration) {
        ClientBuilder builder = PulsarClient.builder();
        Integer requestTimeoutMs = (Integer)configuration.get(PulsarOptions.PULSAR_REQUEST_TIMEOUT_MS);
        builder.loadConf(Collections.singletonMap("requestTimeoutMs", requestTimeoutMs));
        builder.authentication(PulsarClientFactory.createAuthentication(configuration));
        configuration.useOption(PulsarOptions.PULSAR_SERVICE_URL, arg_0 -> ((ClientBuilder)builder).serviceUrl(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_LISTENER_NAME, arg_0 -> ((ClientBuilder)builder).listenerName(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_OPERATION_TIMEOUT_MS, timeout -> builder.operationTimeout(timeout.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_NUM_IO_THREADS, arg_0 -> ((ClientBuilder)builder).ioThreads(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_NUM_LISTENER_THREADS, arg_0 -> ((ClientBuilder)builder).listenerThreads(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_CONNECTIONS_PER_BROKER, arg_0 -> ((ClientBuilder)builder).connectionsPerBroker(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_USE_TCP_NO_DELAY, arg_0 -> ((ClientBuilder)builder).enableTcpNoDelay(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_CERTS_FILE_PATH, arg_0 -> ((ClientBuilder)builder).tlsTrustCertsFilePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_ALLOW_INSECURE_CONNECTION, arg_0 -> ((ClientBuilder)builder).allowTlsInsecureConnection(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_HOSTNAME_VERIFICATION_ENABLE, arg_0 -> ((ClientBuilder)builder).enableTlsHostnameVerification(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_USE_KEY_STORE_TLS, arg_0 -> ((ClientBuilder)builder).useKeyStoreTls(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_SSL_PROVIDER, arg_0 -> ((ClientBuilder)builder).sslProvider(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_TYPE, arg_0 -> ((ClientBuilder)builder).tlsTrustStoreType(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PATH, arg_0 -> ((ClientBuilder)builder).tlsTrustStorePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PASSWORD, arg_0 -> ((ClientBuilder)builder).tlsTrustStorePassword(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_CIPHERS, TreeSet::new, arg_0 -> ((ClientBuilder)builder).tlsCiphers(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_PROTOCOLS, TreeSet::new, arg_0 -> ((ClientBuilder)builder).tlsProtocols(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MEMORY_LIMIT_BYTES, bytes -> builder.memoryLimit(bytes.longValue(), SizeUnit.BYTES));
        configuration.useOption(PulsarOptions.PULSAR_STATS_INTERVAL_SECONDS, v -> builder.statsInterval(v.longValue(), TimeUnit.SECONDS));
        configuration.useOption(PulsarOptions.PULSAR_CONCURRENT_LOOKUP_REQUEST, arg_0 -> ((ClientBuilder)builder).maxConcurrentLookupRequests(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MAX_LOOKUP_REQUEST, arg_0 -> ((ClientBuilder)builder).maxLookupRequests(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MAX_LOOKUP_REDIRECTS, arg_0 -> ((ClientBuilder)builder).maxLookupRedirects(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_MAX_NUMBER_OF_REJECTED_REQUEST_PER_CONNECTION, arg_0 -> ((ClientBuilder)builder).maxNumberOfRejectedRequestPerConnection(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_KEEP_ALIVE_INTERVAL_SECONDS, v -> builder.keepAliveInterval(v.intValue(), TimeUnit.SECONDS));
        configuration.useOption(PulsarOptions.PULSAR_CONNECTION_TIMEOUT_MS, v -> builder.connectionTimeout(v.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_INITIAL_BACKOFF_INTERVAL_NANOS, v -> builder.startingBackoffInterval(v.longValue(), TimeUnit.NANOSECONDS));
        configuration.useOption(PulsarOptions.PULSAR_MAX_BACKOFF_INTERVAL_NANOS, v -> builder.maxBackoffInterval(v.longValue(), TimeUnit.NANOSECONDS));
        configuration.useOption(PulsarOptions.PULSAR_ENABLE_BUSY_WAIT, arg_0 -> ((ClientBuilder)builder).enableBusyWait(arg_0));
        if (configuration.contains(PulsarOptions.PULSAR_PROXY_SERVICE_URL)) {
            String proxyServiceUrl = (String)configuration.get(PulsarOptions.PULSAR_PROXY_SERVICE_URL);
            ProxyProtocol proxyProtocol = (ProxyProtocol)configuration.get(PulsarOptions.PULSAR_PROXY_PROTOCOL);
            builder.proxyServiceUrl(proxyServiceUrl, proxyProtocol);
        }
        configuration.useOption(PulsarOptions.PULSAR_ENABLE_TRANSACTION, arg_0 -> ((ClientBuilder)builder).enableTransaction(arg_0));
        return (PulsarClient)PulsarExceptionUtils.sneakyClient(() -> ((ClientBuilder)builder).build());
    }

    public static PulsarAdmin createAdmin(PulsarConfiguration configuration) {
        PulsarAdminBuilder builder = PulsarAdmin.builder();
        builder.authentication(PulsarClientFactory.createAuthentication(configuration));
        configuration.useOption(PulsarOptions.PULSAR_ADMIN_URL, arg_0 -> ((PulsarAdminBuilder)builder).serviceHttpUrl(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_CERTS_FILE_PATH, arg_0 -> ((PulsarAdminBuilder)builder).tlsTrustCertsFilePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_ALLOW_INSECURE_CONNECTION, arg_0 -> ((PulsarAdminBuilder)builder).allowTlsInsecureConnection(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_HOSTNAME_VERIFICATION_ENABLE, arg_0 -> ((PulsarAdminBuilder)builder).enableTlsHostnameVerification(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_USE_KEY_STORE_TLS, arg_0 -> ((PulsarAdminBuilder)builder).useKeyStoreTls(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_SSL_PROVIDER, arg_0 -> ((PulsarAdminBuilder)builder).sslProvider(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_TYPE, arg_0 -> ((PulsarAdminBuilder)builder).tlsTrustStoreType(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PATH, arg_0 -> ((PulsarAdminBuilder)builder).tlsTrustStorePath(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_TRUST_STORE_PASSWORD, arg_0 -> ((PulsarAdminBuilder)builder).tlsTrustStorePassword(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_CIPHERS, TreeSet::new, arg_0 -> ((PulsarAdminBuilder)builder).tlsCiphers(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_TLS_PROTOCOLS, TreeSet::new, arg_0 -> ((PulsarAdminBuilder)builder).tlsProtocols(arg_0));
        configuration.useOption(PulsarOptions.PULSAR_CONNECT_TIMEOUT, v -> builder.connectionTimeout(v.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_READ_TIMEOUT, v -> builder.readTimeout(v.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_REQUEST_TIMEOUT, v -> builder.requestTimeout(v.intValue(), TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarOptions.PULSAR_AUTO_CERT_REFRESH_TIME, v -> builder.autoCertRefreshTime(v.intValue(), TimeUnit.MILLISECONDS));
        return (PulsarAdmin)PulsarExceptionUtils.sneakyClient(() -> ((PulsarAdminBuilder)builder).build());
    }

    private static Authentication createAuthentication(PulsarConfiguration configuration) {
        if (configuration.contains(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME)) {
            String authPluginClassName = (String)configuration.get(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME);
            if (configuration.contains(PulsarOptions.PULSAR_AUTH_PARAMS)) {
                String authParamsString = (String)configuration.get(PulsarOptions.PULSAR_AUTH_PARAMS);
                return (Authentication)PulsarExceptionUtils.sneakyClient(() -> AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
            }
            if (configuration.contains(PulsarOptions.PULSAR_AUTH_PARAM_MAP)) {
                Map paramsMap = (Map)configuration.get(PulsarOptions.PULSAR_AUTH_PARAM_MAP);
                return (Authentication)PulsarExceptionUtils.sneakyClient(() -> AuthenticationFactory.create((String)authPluginClassName, (Map)paramsMap));
            }
            throw new IllegalArgumentException(String.format("No %s or %s provided", PulsarOptions.PULSAR_AUTH_PARAMS.key(), PulsarOptions.PULSAR_AUTH_PARAM_MAP.key()));
        }
        return AuthenticationDisabled.INSTANCE;
    }
}

