/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source;

import io.debezium.jdbc.JdbcConfiguration;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.relational.connection.ConnectionPoolId;
import org.apache.flink.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;

public class PostgresConnectionPoolFactory
extends JdbcConnectionPoolFactory {
    public static final String JDBC_URL_PATTERN = "jdbc:postgresql://%s:%s/%s";

    public String getJdbcUrl(JdbcSourceConfig sourceConfig) {
        String hostName = sourceConfig.getHostname();
        int port = sourceConfig.getPort();
        String database = (String)sourceConfig.getDatabaseList().get(0);
        return String.format(JDBC_URL_PATTERN, hostName, port, database);
    }

    public ConnectionPoolId getPoolId(JdbcConfiguration config, String dataSourcePoolFactoryIdentifier) {
        return new ConnectionPoolId(config.getHostname(), config.getPort(), config.getHostname(), config.getDatabase(), dataSourcePoolFactoryIdentifier);
    }
}

