/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.connection;

import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.connection.ConnectionPoolId;
import org.apache.flink.cdc.connectors.mysql.source.connection.ConnectionPools;
import org.apache.flink.cdc.connectors.mysql.source.connection.PooledDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionPools
implements ConnectionPools {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionPools.class);
    private static final JdbcConnectionPools INSTANCE = new JdbcConnectionPools();
    private final Map<ConnectionPoolId, HikariDataSource> pools = new HashMap<ConnectionPoolId, HikariDataSource>();

    private JdbcConnectionPools() {
    }

    public static JdbcConnectionPools getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HikariDataSource getOrCreateConnectionPool(ConnectionPoolId poolId, MySqlSourceConfig sourceConfig) {
        Map<ConnectionPoolId, HikariDataSource> map = this.pools;
        synchronized (map) {
            if (!this.pools.containsKey(poolId)) {
                LOG.info("Create and register connection pool {}", (Object)poolId);
                this.pools.put(poolId, PooledDataSourceFactory.createPooledDataSource(sourceConfig));
            }
            return this.pools.get(poolId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Map<ConnectionPoolId, HikariDataSource> map = this.pools;
        synchronized (map) {
            this.pools.values().stream().forEach(HikariDataSource::close);
            this.pools.clear();
        }
    }
}

