/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.debezium.reader;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventType;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.connectors.mysql.debezium.reader.DebeziumReader;
import org.apache.flink.cdc.connectors.mysql.debezium.reader.StoppableChangeEventSourceContext;
import org.apache.flink.cdc.connectors.mysql.debezium.task.MySqlBinlogSplitReadTask;
import org.apache.flink.cdc.connectors.mysql.debezium.task.context.StatefulTaskContext;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.SourceRecords;
import org.apache.flink.cdc.connectors.mysql.source.utils.ChunkUtils;
import org.apache.flink.cdc.connectors.mysql.source.utils.RecordUtils;
import org.apache.flink.cdc.connectors.mysql.table.StartupMode;
import org.apache.flink.cdc.connectors.mysql.table.StartupOptions;
import org.apache.flink.shaded.guava31.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogSplitReader
implements DebeziumReader<SourceRecords, MySqlSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(BinlogSplitReader.class);
    private final StatefulTaskContext statefulTaskContext;
    private final ExecutorService executorService;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile boolean currentTaskRunning;
    private volatile Throwable readException;
    private MySqlBinlogSplitReadTask binlogSplitReadTask;
    private MySqlBinlogSplit currentBinlogSplit;
    private Map<TableId, List<FinishedSnapshotSplitInfo>> finishedSplitsInfo;
    private Map<TableId, BinlogOffset> maxSplitHighWatermarkMap;
    private final Set<TableId> pureBinlogPhaseTables;
    private Tables.TableFilter capturedTableFilter;
    private final StoppableChangeEventSourceContext changeEventSourceContext = new StoppableChangeEventSourceContext();
    private static final long READER_CLOSE_TIMEOUT = 30L;

    public BinlogSplitReader(StatefulTaskContext statefulTaskContext, int subTaskId) {
        this.statefulTaskContext = statefulTaskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("binlog-reader-" + subTaskId).build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.currentTaskRunning = true;
        this.pureBinlogPhaseTables = new HashSet<TableId>();
    }

    @Override
    public void submitSplit(MySqlSplit mySqlSplit) {
        this.currentBinlogSplit = mySqlSplit.asBinlogSplit();
        this.configureFilter();
        this.statefulTaskContext.configure(this.currentBinlogSplit);
        this.capturedTableFilter = this.statefulTaskContext.getConnectorConfig().getTableFilters().dataCollectionFilter();
        this.queue = this.statefulTaskContext.getQueue();
        this.binlogSplitReadTask = new MySqlBinlogSplitReadTask(this.statefulTaskContext.getConnectorConfig(), this.statefulTaskContext.getConnection(), this.statefulTaskContext.getDispatcher(), this.statefulTaskContext.getSignalEventDispatcher(), this.statefulTaskContext.getErrorHandler(), StatefulTaskContext.getClock(), this.statefulTaskContext.getTaskContext(), (MySqlStreamingChangeEventSourceMetrics)this.statefulTaskContext.getStreamingChangeEventSourceMetrics(), this.currentBinlogSplit, this.createEventFilter());
        this.executorService.submit(() -> {
            try {
                this.binlogSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)this.changeEventSourceContext, this.statefulTaskContext.getMySqlPartition(), this.statefulTaskContext.getOffsetContext());
            }
            catch (Exception e) {
                LOG.error(String.format("Execute binlog read task for mysql split %s fail", this.currentBinlogSplit), (Throwable)e);
                this.readException = e;
            }
            finally {
                this.stopBinlogReadTask();
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.currentBinlogSplit == null || !this.currentTaskRunning;
    }

    @Override
    @Nullable
    public Iterator<SourceRecords> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        if (this.currentTaskRunning) {
            List batch = this.queue.poll();
            for (DataChangeEvent event : batch) {
                if (!this.shouldEmit(event.getRecord())) continue;
                sourceRecords.add(event.getRecord());
            }
            ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
            sourceRecordsSet.add(new SourceRecords(sourceRecords));
            return sourceRecordsSet.iterator();
        }
        return null;
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new FlinkRuntimeException(String.format("Read split %s error due to %s.", this.currentBinlogSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.statefulTaskContext.getConnection() != null) {
                this.statefulTaskContext.getConnection().close();
            }
            if (this.statefulTaskContext.getBinaryLogClient() != null) {
                this.statefulTaskContext.getBinaryLogClient().disconnect();
            }
            this.stopBinlogReadTask();
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Failed to close the binlog split reader in {} seconds.", (Object)30L);
                }
            }
            this.statefulTaskContext.getDatabaseSchema().close();
        }
        catch (Exception e) {
            LOG.error("Close binlog reader error", (Throwable)e);
        }
    }

    private boolean shouldEmit(SourceRecord sourceRecord) {
        if (RecordUtils.isDataChangeRecord(sourceRecord)) {
            BinlogOffset position;
            TableId tableId = RecordUtils.getTableId(sourceRecord);
            if (this.hasEnterPureBinlogPhase(tableId, position = RecordUtils.getBinlogPosition(sourceRecord))) {
                return true;
            }
            if (this.finishedSplitsInfo.containsKey(tableId)) {
                RowType splitKeyType = ChunkUtils.getChunkKeyColumnType(this.statefulTaskContext.getDatabaseSchema().tableFor(tableId), this.statefulTaskContext.getSourceConfig().getChunkKeyColumns());
                Struct target = RecordUtils.getStructContainsChunkKey(sourceRecord);
                Object[] chunkKey = RecordUtils.getSplitKey(splitKeyType, this.statefulTaskContext.getSchemaNameAdjuster(), target);
                for (FinishedSnapshotSplitInfo splitInfo : this.finishedSplitsInfo.get(tableId)) {
                    if (!RecordUtils.splitKeyRangeContains(chunkKey, splitInfo.getSplitStart(), splitInfo.getSplitEnd()) || !position.isAfter(splitInfo.getHighWatermark())) continue;
                    return true;
                }
            }
            return false;
        }
        if (RecordUtils.isSchemaChangeEvent(sourceRecord)) {
            if (RecordUtils.isTableChangeRecord(sourceRecord)) {
                TableId tableId = RecordUtils.getTableId(sourceRecord);
                return this.capturedTableFilter.isIncluded(tableId);
            }
            return false;
        }
        return true;
    }

    private boolean hasEnterPureBinlogPhase(TableId tableId, BinlogOffset position) {
        if (this.pureBinlogPhaseTables.contains(tableId)) {
            return true;
        }
        if (this.maxSplitHighWatermarkMap.containsKey(tableId) && position.isAtOrAfter(this.maxSplitHighWatermarkMap.get(tableId))) {
            this.pureBinlogPhaseTables.add(tableId);
            return true;
        }
        if (!this.statefulTaskContext.getSourceConfig().isScanNewlyAddedTableEnabled()) {
            return !this.maxSplitHighWatermarkMap.containsKey(tableId) && this.capturedTableFilter.isIncluded(tableId);
        }
        return false;
    }

    private void configureFilter() {
        List<FinishedSnapshotSplitInfo> finishedSplitInfos = this.currentBinlogSplit.getFinishedSnapshotSplitInfos();
        HashMap<TableId, List<FinishedSnapshotSplitInfo>> splitsInfoMap = new HashMap<TableId, List<FinishedSnapshotSplitInfo>>();
        HashMap<TableId, BinlogOffset> tableIdBinlogPositionMap = new HashMap<TableId, BinlogOffset>();
        if (finishedSplitInfos.isEmpty()) {
            for (TableId tableId : this.currentBinlogSplit.getTableSchemas().keySet()) {
                tableIdBinlogPositionMap.put(tableId, this.currentBinlogSplit.getStartingOffset());
            }
        } else {
            for (FinishedSnapshotSplitInfo finishedSplitInfo : finishedSplitInfos) {
                TableId tableId = finishedSplitInfo.getTableId();
                List list = splitsInfoMap.getOrDefault(tableId, new ArrayList());
                list.add(finishedSplitInfo);
                splitsInfoMap.put(tableId, list);
                BinlogOffset highWatermark = finishedSplitInfo.getHighWatermark();
                BinlogOffset maxHighWatermark = (BinlogOffset)tableIdBinlogPositionMap.get(tableId);
                if (maxHighWatermark != null && !highWatermark.isAfter(maxHighWatermark)) continue;
                tableIdBinlogPositionMap.put(tableId, highWatermark);
            }
        }
        this.finishedSplitsInfo = splitsInfoMap;
        this.maxSplitHighWatermarkMap = tableIdBinlogPositionMap;
        this.pureBinlogPhaseTables.clear();
    }

    private Predicate<Event> createEventFilter() {
        StartupOptions startupOptions = this.statefulTaskContext.getSourceConfig().getStartupOptions();
        if (startupOptions.startupMode.equals((Object)StartupMode.TIMESTAMP)) {
            if (startupOptions.binlogOffset == null) {
                throw new NullPointerException("The startup option was set to TIMESTAMP but unable to find starting binlog offset. Please check if the timestamp is specified in configuration. ");
            }
            long startTimestampSec = startupOptions.binlogOffset.getTimestampSec();
            LOG.info("Creating event filter that dropping row mutation events before timestamp in second {}", (Object)startTimestampSec);
            return event -> {
                if (!EventType.isRowMutation((EventType)this.getEventType((Event)event))) {
                    return true;
                }
                return event.getHeader().getTimestamp() >= startTimestampSec * 1000L;
            };
        }
        return event -> true;
    }

    public void stopBinlogReadTask() {
        this.currentTaskRunning = false;
        this.changeEventSourceContext.stopChangeEventSource();
    }

    private EventType getEventType(Event event) {
        return event.getHeader().getEventType();
    }

    @VisibleForTesting
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @VisibleForTesting
    MySqlBinlogSplitReadTask getBinlogSplitReadTask() {
        return this.binlogSplitReadTask;
    }
}

