/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.testutils;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.cdc.connectors.mysql.testutils.MySqlContainer;
import org.junit.Assert;

public class UniqueDatabase {
    private static final String[] CREATE_DATABASE_DDL = new String[]{"CREATE DATABASE `$DBNAME$`;", "USE `$DBNAME$`;"};
    private static final String DROP_DATABASE_DDL = "DROP DATABASE IF EXISTS `$DBNAME$`;";
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(.*)--.*$");
    private final MySqlContainer container;
    private final String databaseName;
    private final String templateName;
    private final String username;
    private final String password;

    public UniqueDatabase(MySqlContainer container, String databaseName, String username, String password) {
        this(container, databaseName, Integer.toUnsignedString(new Random().nextInt(), 36), username, password);
    }

    private UniqueDatabase(MySqlContainer container, String databaseName, String identifier, String username, String password) {
        this.container = container;
        this.databaseName = databaseName + "_" + identifier;
        this.templateName = databaseName;
        this.username = username;
        this.password = password;
    }

    public String getHost() {
        return this.container.getHost();
    }

    public int getDatabasePort() {
        return this.container.getDatabasePort();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String qualifiedTableName(String tableName) {
        return String.format("%s.%s", this.databaseName, tableName);
    }

    public void createAndInitialize() {
        String ddlFile = String.format("ddl/%s.sql", this.templateName);
        URL ddlTestFile = UniqueDatabase.class.getClassLoader().getResource(ddlFile);
        Assert.assertNotNull((String)("Cannot locate " + ddlFile), (Object)ddlTestFile);
        try (Connection connection = DriverManager.getConnection(this.container.getJdbcUrl(), this.username, this.password);
             Statement statement = connection.createStatement();){
            List statements = Arrays.stream(Stream.concat(Arrays.stream(CREATE_DATABASE_DDL), Files.readAllLines(Paths.get(ddlTestFile.toURI())).stream()).map(String::trim).filter(x -> !x.startsWith("--") && !x.isEmpty()).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).map(this::convertSQL).collect(Collectors.joining("\n")).split(";")).map(x -> x.replace("$$", ";")).collect(Collectors.toList());
            for (String stmt : statements) {
                statement.execute(stmt);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void dropDatabase() {
        try (Connection connection = DriverManager.getConnection(this.container.getJdbcUrl(), this.username, this.password);
             Statement statement = connection.createStatement();){
            String dropDatabaseStatement = this.convertSQL(DROP_DATABASE_DDL);
            statement.execute(dropDatabaseStatement);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Connection getJdbcConnection() throws SQLException {
        return DriverManager.getConnection(this.container.getJdbcUrl(this.databaseName), this.username, this.password);
    }

    private String convertSQL(String sql) {
        return sql.replace("$DBNAME$", this.databaseName);
    }
}

