/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.testutils;

import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.mysql.table.MySqlDeserializationConverterFactory;
import org.apache.flink.cdc.connectors.mysql.testutils.RecordsFormatter;
import org.apache.flink.cdc.connectors.mysql.testutils.UniqueDatabase;
import org.apache.flink.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.RowRowConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.kafka.connect.source.SourceRecord;

public class TestTable {
    private final String databaseName;
    private final String tableName;
    private final ResolvedSchema schema;
    private RowRowConverter rowRowConverter;
    private RowDataDebeziumDeserializeSchema deserializer;
    private RecordsFormatter recordsFormatter;

    public TestTable(UniqueDatabase database, String tableName, ResolvedSchema schema) {
        this(database.getDatabaseName(), tableName, schema);
    }

    public TestTable(String databaseName, String tableName, ResolvedSchema schema) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.schema = schema;
    }

    public String getTableId() {
        return String.format("%s.%s", this.databaseName, this.tableName);
    }

    public RowType getRowType() {
        return (RowType)this.schema.toPhysicalRowDataType().getLogicalType();
    }

    public RowDataDebeziumDeserializeSchema getDeserializer() {
        if (this.deserializer == null) {
            this.deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(this.getRowType()).setResultTypeInfo((TypeInformation)InternalTypeInfo.of((RowType)this.getRowType())).setUserDefinedConverterFactory(MySqlDeserializationConverterFactory.instance()).build();
        }
        return this.deserializer;
    }

    public RowRowConverter getRowRowConverter() {
        if (this.rowRowConverter == null) {
            this.rowRowConverter = RowRowConverter.create((DataType)this.schema.toPhysicalRowDataType());
        }
        return this.rowRowConverter;
    }

    public RecordsFormatter getRecordsFormatter() {
        if (this.recordsFormatter == null) {
            this.recordsFormatter = new RecordsFormatter(this.schema.toPhysicalRowDataType());
        }
        return this.recordsFormatter;
    }

    public String stringify(RowData rowData) {
        return this.getRowRowConverter().toExternal(rowData).toString();
    }

    public List<String> stringify(List<SourceRecord> sourceRecord) {
        return this.getRecordsFormatter().format(sourceRecord);
    }
}

