/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.testutils;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.mysql.source.utils.RecordUtils;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.RowRowConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.kafka.connect.source.SourceRecord;

public class RecordsFormatter {
    private final DataType dataType;
    private final ZoneId zoneId;
    private TypeInformation<RowData> typeInfo;
    private DebeziumDeserializationSchema<RowData> deserializationSchema;
    private SimpleCollector collector;
    private RowRowConverter rowRowConverter;

    public RecordsFormatter(DataType dataType) {
        this(dataType, ZoneId.of("UTC"));
    }

    public RecordsFormatter(DataType dataType, ZoneId zoneId) {
        this.dataType = dataType;
        this.zoneId = zoneId;
        this.typeInfo = TypeConversions.fromDataTypeToLegacyInfo((DataType)dataType);
        this.deserializationSchema = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType((RowType)dataType.getLogicalType()).setResultTypeInfo(this.typeInfo).build();
        this.collector = new SimpleCollector();
        this.rowRowConverter = RowRowConverter.create((DataType)dataType);
        this.rowRowConverter.open(Thread.currentThread().getContextClassLoader());
    }

    public List<String> format(List<SourceRecord> records) {
        records.stream().filter(RecordUtils::isDataChangeRecord).forEach(r -> {
            try {
                this.deserializationSchema.deserialize(r, (Collector)this.collector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return this.collector.list.stream().map(arg_0 -> ((RowRowConverter)this.rowRowConverter).toExternal(arg_0)).map(Row::toString).collect(Collectors.toList());
    }

    private static class SimpleCollector
    implements Collector<RowData> {
        private List<RowData> list = new ArrayList<RowData>();

        private SimpleCollector() {
        }

        public void collect(RowData record) {
            this.list.add(record);
        }

        public void close() {
        }
    }
}

