/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.table;

import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import org.apache.flink.cdc.connectors.mysql.table.MySqlTableSource;
import org.apache.flink.cdc.connectors.mysql.table.MySqlTableSourceFactory;
import org.apache.flink.cdc.connectors.mysql.table.StartupOptions;
import org.apache.flink.cdc.debezium.utils.ResolvedSchemaUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.ExceptionUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MySqlTableSourceFactoryTest {
    private static final ResolvedSchema SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"aaa", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"bbb", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"ccc", (DataType)DataTypes.DOUBLE()), Column.physical((String)"ddd", (DataType)DataTypes.DECIMAL((int)31, (int)18)), Column.physical((String)"eee", (DataType)DataTypes.TIMESTAMP((int)3))), new ArrayList(), UniqueConstraint.primaryKey((String)"pk", Arrays.asList("bbb", "aaa")));
    private static final ResolvedSchema SCHEMA_WITH_METADATA = new ResolvedSchema(Arrays.asList(Column.physical((String)"id", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"count", (DataType)DataTypes.DECIMAL((int)38, (int)18)), Column.metadata((String)"time", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), (String)"op_ts", (boolean)true), Column.metadata((String)"database_name", (DataType)DataTypes.STRING(), (String)"database_name", (boolean)true)), Collections.emptyList(), UniqueConstraint.primaryKey((String)"pk", Collections.singletonList("id")));
    private static final String MY_LOCALHOST = "localhost";
    private static final String MY_USERNAME = "flinkuser";
    private static final String MY_PASSWORD = "flinkpw";
    private static final String MY_DATABASE = "myDB";
    private static final String MY_TABLE = "myTable";
    private static final Properties PROPERTIES = new Properties();

    @Test
    public void testCommonProperties() {
        Map<String, String> properties = this.getAllOptions();
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, null, false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.initial(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testEnableParallelReadSource() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("scan.incremental.snapshot.enabled", "true");
        properties.put("server-id", "123-126");
        properties.put("scan.incremental.snapshot.chunk.size", "8000");
        properties.put("chunk-meta.group.size", "3000");
        properties.put("chunk-key.even-distribution.factor.upper-bound", "40.5");
        properties.put("chunk-key.even-distribution.factor.lower-bound", "0.01");
        properties.put("scan.snapshot.fetch.size", "100");
        properties.put("connect.timeout", "45s");
        properties.put("scan.incremental.snapshot.chunk.key-column", "testCol");
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, "123-126", true, 8000, 3000, 100, Duration.ofSeconds(45L), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), 40.5, 0.01, StartupOptions.initial(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), "testCol", ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testEnableParallelReadSourceWithSingleServerId() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("scan.incremental.snapshot.enabled", "true");
        properties.put("server-id", "123");
        properties.put("scan.incremental.snapshot.chunk.size", "8000");
        properties.put("scan.snapshot.fetch.size", "100");
        properties.put("connect.timeout", "45s");
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, "123", true, 8000, ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), 100, Duration.ofSeconds(45L), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.initial(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testEnableParallelReadSourceLatestOffset() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("scan.incremental.snapshot.enabled", "true");
        properties.put("server-id", "123-126");
        properties.put("scan.startup.mode", "latest-offset");
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, "123-126", ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED.defaultValue()).booleanValue(), ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.latest(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testOptionalProperties() {
        Map<String, String> options = this.getAllOptions();
        options.put("port", "3307");
        options.put("server-id", "4321");
        options.put("server-time-zone", "Asia/Shanghai");
        options.put("scan.newly-added-table.enabled", "true");
        options.put("debezium.snapshot.mode", "never");
        options.put("jdbc.properties.useSSL", "false");
        options.put("heartbeat.interval", "15213ms");
        options.put("scan.incremental.snapshot.chunk.key-column", "testCol");
        options.put("scan.incremental.close-idle-reader.enabled", "true");
        options.put("scan.incremental.snapshot.backfill.skip", "true");
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(options);
        Properties dbzProperties = new Properties();
        dbzProperties.put("snapshot.mode", "never");
        Properties jdbcProperties = new Properties();
        jdbcProperties.setProperty("useSSL", "false");
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3307, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.of("Asia/Shanghai"), dbzProperties, "4321", false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.initial(), true, true, jdbcProperties, Duration.ofMillis(15213L), "testCol", true);
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testStartupFromSpecificOffset() {
        String offsetFile = "mysql-bin.000003";
        int offsetPos = 100203;
        Map<String, String> properties = this.getAllOptions();
        properties.put("port", "3307");
        properties.put("server-id", "4321");
        properties.put("scan.startup.mode", "specific-offset");
        properties.put("scan.startup.specific-offset.file", "mysql-bin.000003");
        properties.put("scan.startup.specific-offset.pos", String.valueOf(100203));
        MySqlTableSourceFactoryTest.createTableSource(properties);
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3307, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, "4321", false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.specificOffset((String)"mysql-bin.000003", (long)100203L), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testStartupFromInitial() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("scan.startup.mode", "initial");
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, null, false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.initial(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testStartupFromEarliestOffset() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("scan.startup.mode", "earliest-offset");
        MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSourceFactoryTest.createTableSource(properties);
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, null, false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.earliest(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testStartupFromSpecificTimestamp() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("scan.startup.mode", "timestamp");
        properties.put("scan.startup.timestamp-millis", "0");
        MySqlTableSourceFactoryTest.createTableSource(properties);
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, null, false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.timestamp((long)0L), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testStartupFromLatestOffset() {
        Map<String, String> properties = this.getAllOptions();
        properties.put("scan.startup.mode", "latest-offset");
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(properties);
        MySqlTableSource expectedSource = new MySqlTableSource(SCHEMA, 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, null, false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.latest(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testMetadataColumns() {
        Map<String, String> properties = this.getAllOptions();
        DynamicTableSource actualSource = MySqlTableSourceFactoryTest.createTableSource(SCHEMA_WITH_METADATA, properties);
        MySqlTableSource mySqlSource = (MySqlTableSource)actualSource;
        mySqlSource.applyReadableMetadata(Arrays.asList("op_ts", "database_name"), SCHEMA_WITH_METADATA.toSourceRowDataType());
        actualSource = mySqlSource.copy();
        MySqlTableSource expectedSource = new MySqlTableSource(ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)SCHEMA_WITH_METADATA), 3306, MY_LOCALHOST, MY_DATABASE, MY_TABLE, MY_USERNAME, MY_PASSWORD, ZoneId.systemDefault(), PROPERTIES, null, false, ((Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue()).intValue(), (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue(), ((Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue()).intValue(), ((Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue()).intValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue()).doubleValue(), ((Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue()).doubleValue(), StartupOptions.initial(), false, false, new Properties(), (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue(), null, ((Boolean)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue()).booleanValue());
        expectedSource.producedDataType = SCHEMA_WITH_METADATA.toSourceRowDataType();
        expectedSource.metadataKeys = Arrays.asList("op_ts", "database_name");
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testValidation() {
        String msg;
        Map<String, String> properties;
        Map<String, String> properties2;
        try {
            properties2 = this.getAllOptions();
            properties2.put("port", "123b");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"Could not parse value '123b' for key 'port'.").isPresent());
        }
        try {
            properties2 = this.getAllOptions();
            properties2.put("server-id", "123b");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"The value of option 'server-id' is invalid: '123b'").isPresent());
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"The server id 123b is not a valid numeric.").isPresent());
        }
        try {
            properties2 = this.getAllOptions();
            properties2.put("scan.incremental.snapshot.enabled", "true");
            properties2.put("scan.incremental.snapshot.chunk.size", "1");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"The value of option 'scan.incremental.snapshot.chunk.size' must larger than 1, but is 1"));
        }
        try {
            properties2 = this.getAllOptions();
            properties2.put("scan.incremental.snapshot.enabled", "true");
            properties2.put("scan.snapshot.fetch.size", "1");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"The value of option 'scan.snapshot.fetch.size' must larger than 1, but is 1"));
        }
        try {
            properties2 = this.getAllOptions();
            properties2.put("scan.incremental.snapshot.enabled", "true");
            properties2.put("chunk-meta.group.size", "1");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"The value of option 'chunk-meta.group.size' must larger than 1, but is 1"));
        }
        try {
            properties2 = this.getAllOptions();
            properties2.put("scan.incremental.snapshot.enabled", "true");
            properties2.put("split-key.even-distribution.factor.upper-bound", "0.8");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"The value of option 'chunk-key.even-distribution.factor.upper-bound' must larger than or equals 1.0, but is 0.8"));
        }
        try {
            properties2 = this.getAllOptions();
            properties2.put("scan.incremental.snapshot.enabled", "true");
            properties2.put("connection.pool.size", "1");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"The value of option 'connection.pool.size' must larger than 1, but is 1"));
        }
        try {
            properties2 = this.getAllOptions();
            properties2.put("scan.incremental.snapshot.enabled", "true");
            properties2.put("connect.max-retries", "0");
            MySqlTableSourceFactoryTest.createTableSource(properties2);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"The value of option 'connect.max-retries' must larger than 0, but is 0"));
        }
        MySqlTableSourceFactory factory = new MySqlTableSourceFactory();
        for (ConfigOption requiredOption : factory.requiredOptions()) {
            Map<String, String> properties3 = this.getAllOptions();
            properties3.remove(requiredOption.key());
            try {
                MySqlTableSourceFactoryTest.createTableSource(properties3);
                Assert.fail((String)"exception expected");
            }
            catch (Throwable t) {
                Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)("Missing required options are:\n\n" + requiredOption.key())).isPresent());
            }
        }
        try {
            properties = this.getAllOptions();
            properties.put("unknown", "abc");
            MySqlTableSourceFactoryTest.createTableSource(properties);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"Unsupported options:\n\nunknown").isPresent());
        }
        try {
            properties = this.getAllOptions();
            properties.put("scan.startup.mode", "abc");
            MySqlTableSourceFactoryTest.createTableSource(properties);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            msg = "Invalid value for option 'scan.startup.mode'. Supported values are [initial, snapshot, latest-offset, earliest-offset, specific-offset, timestamp], but was: abc";
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)msg).isPresent());
        }
        try {
            properties = this.getAllOptions();
            properties.put("database-name", "*_invalid_db");
        }
        catch (Throwable t) {
            msg = String.format("The database-name '%s' is not a valid regular expression", "*_invalid_db");
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)msg).isPresent());
        }
        try {
            properties = this.getAllOptions();
            properties.put("table-name", "*_invalid_table");
        }
        catch (Throwable t) {
            msg = String.format("The table-name '%s' is not a valid regular expression", "*_invalid_table");
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)msg).isPresent());
        }
    }

    private Map<String, String> getAllOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "mysql-cdc");
        options.put("hostname", MY_LOCALHOST);
        options.put("database-name", MY_DATABASE);
        options.put("table-name", MY_TABLE);
        options.put("username", MY_USERNAME);
        options.put("password", MY_PASSWORD);
        options.put("scan.incremental.snapshot.enabled", String.valueOf(false));
        return options;
    }

    private static DynamicTableSource createTableSource(ResolvedSchema schema, Map<String, String> options) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)ObjectIdentifier.of((String)"default", (String)"default", (String)"t1"), (ResolvedCatalogTable)new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (String)"mock source", new ArrayList(), options), schema), (ReadableConfig)new Configuration(), (ClassLoader)MySqlTableSourceFactoryTest.class.getClassLoader(), (boolean)false);
    }

    private static DynamicTableSource createTableSource(Map<String, String> options) {
        return MySqlTableSourceFactoryTest.createTableSource(SCHEMA, options);
    }
}

