/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.utils.SerializerUtils;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.junit.Assert;
import org.junit.Test;

public class SerializerUtilsTest {
    @Test
    public void testBinlogOffsetSerde() throws Exception {
        for (BinlogOffset offset : this.createBinlogOffsets()) {
            byte[] serialized = this.serializeBinlogOffset(offset);
            BinlogOffset deserialized = this.deserializeBinlogOffset(serialized);
            Assert.assertEquals((Object)offset, (Object)deserialized);
        }
    }

    @Test
    public void testDeserializeFromBinlogOffsetWithoutKind() throws Exception {
        HashMap<String, String> initialOffsetMap = new HashMap<String, String>();
        initialOffsetMap.put("file", "");
        initialOffsetMap.put("pos", "0");
        BinlogOffset initialOffset = new BinlogOffset(initialOffsetMap);
        BinlogOffset deserialized = this.deserializeBinlogOffset(this.serializeBinlogOffset(initialOffset));
        Assert.assertEquals((Object)BinlogOffset.ofEarliest(), (Object)deserialized);
        HashMap<String, String> nonStoppingOffsetMap = new HashMap<String, String>();
        nonStoppingOffsetMap.put("file", "");
        nonStoppingOffsetMap.put("pos", Long.toString(Long.MIN_VALUE));
        BinlogOffset nonStoppingOffset = new BinlogOffset(nonStoppingOffsetMap);
        deserialized = this.deserializeBinlogOffset(this.serializeBinlogOffset(nonStoppingOffset));
        Assert.assertEquals((Object)BinlogOffset.ofNonStopping(), (Object)deserialized);
        HashMap<String, String> specificOffsetMap = new HashMap<String, String>();
        specificOffsetMap.put("file", "mysql-bin.000001");
        specificOffsetMap.put("pos", "4");
        specificOffsetMap.put("gtids", "24DA167-0C0C-11E8-8442-00059A3C7B00:1-19");
        specificOffsetMap.put("ts_sec", "1668690384");
        specificOffsetMap.put("event", "15213");
        specificOffsetMap.put("row", "18613");
        BinlogOffset specificOffset = new BinlogOffset(specificOffsetMap);
        deserialized = this.deserializeBinlogOffset(this.serializeBinlogOffset(specificOffset));
        Assert.assertEquals((Object)BinlogOffset.builder().setBinlogFilePosition("mysql-bin.000001", 4L).setGtidSet("24DA167-0C0C-11E8-8442-00059A3C7B00:1-19").setTimestampSec(1668690384L).setSkipEvents(15213L).setSkipRows(18613L).build(), (Object)deserialized);
    }

    private List<BinlogOffset> createBinlogOffsets() {
        return Arrays.asList(BinlogOffset.ofBinlogFilePosition((String)"foo-filename", (long)15213L), BinlogOffset.ofGtidSet((String)"foo-gtid"), BinlogOffset.ofTimestampSec((long)15513L), BinlogOffset.ofNonStopping(), BinlogOffset.ofEarliest(), BinlogOffset.ofLatest(), BinlogOffset.builder().setGtidSet("foo-gtid").setSkipEvents(18213L).setSkipRows(18613L).build());
    }

    private byte[] serializeBinlogOffset(BinlogOffset binlogOffset) throws IOException {
        DataOutputSerializer dos = new DataOutputSerializer(64);
        SerializerUtils.writeBinlogPosition((BinlogOffset)binlogOffset, (DataOutputSerializer)dos);
        return dos.getCopyOfBuffer();
    }

    private BinlogOffset deserializeBinlogOffset(byte[] serialized) throws IOException {
        DataInputDeserializer did = new DataInputDeserializer(serialized);
        return SerializerUtils.readBinlogPosition((int)4, (DataInputDeserializer)did);
    }
}

