/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.flink.cdc.connectors.mysql.source.utils.RecordUtils;
import org.junit.Assert;
import org.junit.Test;

public class RecordUtilsTest {
    @Test
    public void testSplitKeyRangeContains() {
        this.assertKeyRangeContains(new Object[]{100L}, null, null);
        this.assertKeyRangeContains(new Object[]{101L}, new Object[]{100L}, null);
        this.assertKeyRangeContains(new Object[]{101L}, null, new Object[]{1024L});
        this.assertKeyRangeContains(new Object[]{100L}, new Object[]{1L}, new Object[]{1024L});
        Assert.assertFalse((boolean)RecordUtils.splitKeyRangeContains((Object[])new Object[]{0L}, (Object[])new Object[]{1L}, (Object[])new Object[]{1024L}));
        this.assertKeyRangeContains(new Object[]{BigInteger.valueOf(100L)}, new Object[]{1L}, new Object[]{1024L});
        Assert.assertFalse((boolean)RecordUtils.splitKeyRangeContains((Object[])new Object[]{BigInteger.valueOf(0L)}, (Object[])new Object[]{1L}, (Object[])new Object[]{1024L}));
    }

    @Test
    public void testDifferentKeyTypes() {
        this.assertKeyRangeContains(new Object[]{5}, null, new Object[]{Byte.valueOf("6")});
        this.assertKeyRangeContains(new Object[]{5}, null, new Object[]{Short.valueOf("6")});
        this.assertKeyRangeContains(new Object[]{5}, null, new Object[]{Integer.valueOf("6")});
        this.assertKeyRangeContains(new Object[]{5}, null, new Object[]{Long.valueOf("6")});
        this.assertKeyRangeContains(new Object[]{5}, null, new Object[]{BigInteger.valueOf(6L)});
        this.assertKeyRangeContains(new Object[]{5}, null, new Object[]{BigDecimal.valueOf(6L)});
        this.assertKeyRangeContains(new Object[]{Byte.valueOf("6")}, new Object[]{Byte.valueOf("6")}, new Object[]{BigDecimal.valueOf(100000L)});
        this.assertKeyRangeContains(new Object[]{Short.valueOf("60")}, new Object[]{Short.valueOf("6")}, new Object[]{BigDecimal.valueOf(100000L)});
        this.assertKeyRangeContains(new Object[]{Integer.valueOf("600")}, new Object[]{Integer.valueOf("6")}, new Object[]{BigDecimal.valueOf(100000L)});
        this.assertKeyRangeContains(new Object[]{Long.valueOf("6000")}, new Object[]{Long.valueOf("6")}, new Object[]{BigDecimal.valueOf(100000L)});
        this.assertKeyRangeContains(new Object[]{BigInteger.valueOf(60000L)}, new Object[]{BigInteger.valueOf(6L)}, new Object[]{BigDecimal.valueOf(100000L)});
        this.assertKeyRangeContains(new Object[]{BigDecimal.valueOf(60000L)}, new Object[]{BigDecimal.valueOf(6L)}, new Object[]{BigDecimal.valueOf(100000L)});
        this.assertKeyRangeContains(new Object[]{7}, new Object[]{Byte.valueOf("6")}, null);
        this.assertKeyRangeContains(new Object[]{7}, new Object[]{Short.valueOf("6")}, null);
        this.assertKeyRangeContains(new Object[]{7}, new Object[]{Integer.valueOf("6")}, null);
        this.assertKeyRangeContains(new Object[]{7}, new Object[]{Long.valueOf("6")}, null);
        this.assertKeyRangeContains(new Object[]{7}, new Object[]{BigInteger.valueOf(6L)}, null);
        this.assertKeyRangeContains(new Object[]{7}, new Object[]{BigDecimal.valueOf(6L)}, null);
    }

    private void assertKeyRangeContains(Object[] key, Object[] splitKeyStart, Object[] splitKeyEnd) {
        Assert.assertTrue((boolean)RecordUtils.splitKeyRangeContains((Object[])key, (Object[])splitKeyStart, (Object[])splitKeyEnd));
    }
}

