/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.split;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplitState;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSnapshotSplitState;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitSerializerTest;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.junit.Assert;
import org.junit.Test;

public class MySqlSplitStateTest {
    @Test
    public void testFromToSplit() {
        MySqlSnapshotSplit split = new MySqlSnapshotSplit(TableId.parse((String)"test_db.test_table"), "test_db.test_table-1", new RowType(Collections.singletonList(new RowType.RowField("id", (LogicalType)new BigIntType()))), new Object[]{100L}, new Object[]{999L}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000002", (long)78L), new HashMap());
        MySqlSnapshotSplitState mySqlSplitState = new MySqlSnapshotSplitState(split);
        Assert.assertEquals((Object)split, (Object)mySqlSplitState.toMySqlSplit());
    }

    @Test
    public void testRecordSnapshotSplitState() {
        MySqlSnapshotSplit split = new MySqlSnapshotSplit(TableId.parse((String)"test_db.test_table"), "test_db.test_table-1", new RowType(Collections.singletonList(new RowType.RowField("id", (LogicalType)new BigIntType()))), new Object[]{100L}, new Object[]{999L}, null, new HashMap());
        MySqlSnapshotSplitState mySqlSplitState = new MySqlSnapshotSplitState(split);
        mySqlSplitState.setHighWatermark(BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000002", (long)78L));
        MySqlSnapshotSplit expected = new MySqlSnapshotSplit(TableId.parse((String)"test_db.test_table"), "test_db.test_table-1", new RowType(Collections.singletonList(new RowType.RowField("id", (LogicalType)new BigIntType()))), new Object[]{100L}, new Object[]{999L}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000002", (long)78L), new HashMap());
        Assert.assertEquals((Object)expected, (Object)mySqlSplitState.toMySqlSplit());
    }

    @Test
    public void testRecordBinlogSplitState() throws Exception {
        MySqlBinlogSplit split = this.getTestBinlogSplitWithOffset(BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)4L));
        MySqlBinlogSplitState mySqlSplitState = new MySqlBinlogSplitState(split);
        mySqlSplitState.setStartingOffset(BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)100L));
        Assert.assertEquals((Object)this.getTestBinlogSplitWithOffset(BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)100L)), (Object)mySqlSplitState.toMySqlSplit());
        mySqlSplitState.setStartingOffset(BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)400L));
        Assert.assertEquals((Object)this.getTestBinlogSplitWithOffset(BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)400L)), (Object)mySqlSplitState.toMySqlSplit());
    }

    private MySqlBinlogSplit getTestBinlogSplitWithOffset(BinlogOffset startingOffset) throws Exception {
        TableId tableId = TableId.parse((String)"test_db.test_table");
        ArrayList<FinishedSnapshotSplitInfo> finishedSplitsInfo = new ArrayList<FinishedSnapshotSplitInfo>();
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-0", null, new Object[]{100}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)4L)));
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-1", new Object[]{100}, new Object[]{200}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)200L)));
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-2", new Object[]{200}, new Object[]{300}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)600L)));
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-3", new Object[]{300}, null, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)800L)));
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        tableSchemas.put(tableId, MySqlSplitSerializerTest.getTestTableSchema());
        return new MySqlBinlogSplit("binlog-split", startingOffset, BinlogOffset.ofNonStopping(), finishedSplitsInfo, tableSchemas, finishedSplitsInfo.size());
    }
}

