/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.split;

import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitSerializer;
import org.apache.flink.cdc.debezium.history.FlinkJsonTableChangeSerializer;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.junit.Assert;
import org.junit.Test;

public class MySqlSplitSerializerTest {
    @Test
    public void testSnapshotSplit() throws Exception {
        MySqlSnapshotSplit split = new MySqlSnapshotSplit(TableId.parse((String)"test_db.test_table"), "test_db.test_table-1", new RowType(Collections.singletonList(new RowType.RowField("id", (LogicalType)new BigIntType()))), new Object[]{100L}, new Object[]{999L}, null, new HashMap());
        Assert.assertEquals((Object)split, (Object)this.serializeAndDeserializeSplit((MySqlSplit)split));
    }

    @Test
    public void testBinlogSplit() throws Exception {
        TableId tableId = TableId.parse((String)"test_db.test_table");
        ArrayList<FinishedSnapshotSplitInfo> finishedSplitsInfo = new ArrayList<FinishedSnapshotSplitInfo>();
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-0", null, new Object[]{100}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)4L)));
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-1", new Object[]{100}, new Object[]{200}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)200L)));
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-2", new Object[]{200}, new Object[]{300}, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)600L)));
        finishedSplitsInfo.add(new FinishedSnapshotSplitInfo(tableId, tableId + "-3", new Object[]{300}, null, BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)800L)));
        HashMap<TableId, TableChanges.TableChange> databaseHistory = new HashMap<TableId, TableChanges.TableChange>();
        databaseHistory.put(tableId, MySqlSplitSerializerTest.getTestTableSchema());
        MySqlBinlogSplit split = new MySqlBinlogSplit("binlog-split", BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)4L), BinlogOffset.ofNonStopping(), finishedSplitsInfo, databaseHistory, finishedSplitsInfo.size());
        Assert.assertEquals((Object)split, (Object)this.serializeAndDeserializeSplit((MySqlSplit)split));
        MySqlBinlogSplit suspendedBinlogSplit = MySqlBinlogSplit.toSuspendedBinlogSplit((MySqlBinlogSplit)split.asBinlogSplit());
        Assert.assertEquals((Object)suspendedBinlogSplit, (Object)this.serializeAndDeserializeSplit((MySqlSplit)suspendedBinlogSplit));
        MySqlBinlogSplit unCompletedBinlogSplit = new MySqlBinlogSplit("binlog-split", BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)4L), BinlogOffset.ofNonStopping(), new ArrayList(), new HashMap(), 0);
        Assert.assertEquals((Object)unCompletedBinlogSplit, (Object)this.serializeAndDeserializeSplit((MySqlSplit)unCompletedBinlogSplit));
    }

    @Test
    public void testRepeatedSerializationCache() throws Exception {
        MySqlSnapshotSplit split = new MySqlSnapshotSplit(TableId.parse((String)"test_db.test_table"), "test_db.test_table-0", new RowType(Collections.singletonList(new RowType.RowField("id", (LogicalType)new BigIntType()))), null, new Object[]{99L}, null, new HashMap());
        byte[] ser1 = MySqlSplitSerializer.INSTANCE.serialize((MySqlSplit)split);
        byte[] ser2 = MySqlSplitSerializer.INSTANCE.serialize((MySqlSplit)split);
        Assert.assertSame((Object)ser1, (Object)ser2);
    }

    private MySqlSplit serializeAndDeserializeSplit(MySqlSplit split) throws Exception {
        MySqlSplitSerializer sqlSplitSerializer = new MySqlSplitSerializer();
        byte[] serialized = sqlSplitSerializer.serialize(split);
        return sqlSplitSerializer.deserialize(sqlSplitSerializer.getVersion(), serialized);
    }

    public static TableChanges.TableChange getTestTableSchema() throws Exception {
        String tableChangeJsonStr = "{\"type\":\"CREATE\",\"id\":\"\\\"test_db\\\".\\\"test_table\\\"\",\"table\":{\"defaultCharsetName\":\"latin1\",\"primaryKeyColumnNames\":[\"card_no\",\"level\"],\"columns\":[{\"name\":\"card_no\",\"jdbcType\":-5,\"typeName\":\"BIGINT\",\"typeExpression\":\"BIGINT\",\"charsetName\":null,\"length\":20,\"position\":1,\"optional\":false,\"autoIncremented\":false,\"generated\":false},{\"name\":\"level\",\"jdbcType\":12,\"typeName\":\"VARCHAR\",\"typeExpression\":\"VARCHAR\",\"charsetName\":\"latin1\",\"length\":10,\"position\":2,\"optional\":false,\"autoIncremented\":false,\"generated\":false},{\"name\":\"name\",\"jdbcType\":12,\"typeName\":\"VARCHAR\",\"typeExpression\":\"VARCHAR\",\"charsetName\":\"latin1\",\"length\":255,\"position\":3,\"optional\":false,\"autoIncremented\":false,\"generated\":false},{\"name\":\"note\",\"jdbcType\":12,\"typeName\":\"VARCHAR\",\"typeExpression\":\"VARCHAR\",\"charsetName\":\"latin1\",\"length\":1024,\"position\":4,\"optional\":true,\"autoIncremented\":false,\"generated\":false}]}}";
        Document doc = DocumentReader.defaultReader().read("{\"type\":\"CREATE\",\"id\":\"\\\"test_db\\\".\\\"test_table\\\"\",\"table\":{\"defaultCharsetName\":\"latin1\",\"primaryKeyColumnNames\":[\"card_no\",\"level\"],\"columns\":[{\"name\":\"card_no\",\"jdbcType\":-5,\"typeName\":\"BIGINT\",\"typeExpression\":\"BIGINT\",\"charsetName\":null,\"length\":20,\"position\":1,\"optional\":false,\"autoIncremented\":false,\"generated\":false},{\"name\":\"level\",\"jdbcType\":12,\"typeName\":\"VARCHAR\",\"typeExpression\":\"VARCHAR\",\"charsetName\":\"latin1\",\"length\":10,\"position\":2,\"optional\":false,\"autoIncremented\":false,\"generated\":false},{\"name\":\"name\",\"jdbcType\":12,\"typeName\":\"VARCHAR\",\"typeExpression\":\"VARCHAR\",\"charsetName\":\"latin1\",\"length\":255,\"position\":3,\"optional\":false,\"autoIncremented\":false,\"generated\":false},{\"name\":\"note\",\"jdbcType\":12,\"typeName\":\"VARCHAR\",\"typeExpression\":\"VARCHAR\",\"charsetName\":\"latin1\",\"length\":1024,\"position\":4,\"optional\":true,\"autoIncremented\":false,\"generated\":false}]}}");
        return FlinkJsonTableChangeSerializer.fromDocument((Document)doc, (boolean)true);
    }
}

