/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.reader;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.heartbeat.HeartbeatFactory;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.Collections;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.cdc.connectors.mysql.source.metrics.MySqlSourceReaderMetrics;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlRecordEmitter;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplitState;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitState;
import org.apache.flink.cdc.connectors.mysql.source.split.SourceRecords;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.connector.testutils.source.reader.TestingReaderOutput;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.util.Collector;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;
import org.junit.Test;

public class MySqlRecordEmitterTest {
    @Test
    public void testHeartbeatEventHandling() throws Exception {
        Configuration dezConf = ((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.create().with(Heartbeat.HEARTBEAT_INTERVAL, 100)).with(CommonConnectorConfig.TRANSACTION_TOPIC, "fake-topic")).with(MySqlConnectorConfig.SERVER_NAME, "mysql_binlog_source")).build();
        MySqlConnectorConfig mySqlConfig = new MySqlConnectorConfig(dezConf);
        HeartbeatFactory heartbeatFactory = new HeartbeatFactory((CommonConnectorConfig)new MySqlConnectorConfig(dezConf), TopicSelector.defaultSelector((CommonConnectorConfig)mySqlConfig, (id, prefix, delimiter) -> "fake-topic"), SchemaNameAdjuster.create());
        Heartbeat heartbeat = heartbeatFactory.createHeartbeat();
        BinlogOffset fakeOffset = BinlogOffset.ofBinlogFilePosition((String)"fake-file", (long)15213L);
        MySqlRecordEmitter<Void> recordEmitter = this.createRecordEmitter();
        MySqlBinlogSplitState splitState = this.createBinlogSplitState();
        heartbeat.forcedBeat(Collections.emptyMap(), fakeOffset.getOffset(), record -> {
            try {
                recordEmitter.emitRecord(SourceRecords.fromSingleRecord((SourceRecord)record), (SourceOutput)new TestingReaderOutput(), (MySqlSplitState)splitState);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to emit heartbeat record", e);
            }
        });
        heartbeat.close();
        Assert.assertNotNull((Object)splitState.getStartingOffset());
        Assert.assertEquals((long)0L, (long)splitState.getStartingOffset().compareTo(fakeOffset));
    }

    private MySqlRecordEmitter<Void> createRecordEmitter() {
        return new MySqlRecordEmitter((DebeziumDeserializationSchema)new DebeziumDeserializationSchema<Void>(){

            public void deserialize(SourceRecord record, Collector<Void> out) {
                throw new UnsupportedOperationException();
            }

            public TypeInformation<Void> getProducedType() {
                return TypeInformation.of(Void.class);
            }
        }, new MySqlSourceReaderMetrics((MetricGroup)UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup()), false);
    }

    private MySqlBinlogSplitState createBinlogSplitState() {
        return new MySqlBinlogSplitState(new MySqlBinlogSplit("binlog-split", BinlogOffset.ofEarliest(), BinlogOffset.ofNonStopping(), Collections.emptyList(), Collections.emptyMap(), 0));
    }
}

