/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.assigners.state;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.connectors.mysql.source.assigners.AssignerStatus;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.BinlogPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.ChunkSplitterState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.HybridPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.PendingSplitsStateSerializer;
import org.apache.flink.cdc.connectors.mysql.source.assigners.state.SnapshotPendingSplitsState;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSchemalessSnapshotSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PendingSplitsStateSerializerTest {
    private static final TableId tableId0 = TableId.parse((String)"test_db.test_table");
    private static final TableId tableId1 = TableId.parse((String)"test_db.test_table1");
    private static final TableId tableId2 = TableId.parse((String)"test_db.test_table2");
    @Parameterized.Parameter
    public PendingSplitsState state;

    @Parameterized.Parameters(name="PendingSplitsState = {index}")
    public static Collection<PendingSplitsState> params() {
        return Arrays.asList(PendingSplitsStateSerializerTest.getTestSnapshotPendingSplitsState(true), PendingSplitsStateSerializerTest.getTestSnapshotPendingSplitsState(false), PendingSplitsStateSerializerTest.getTestHybridPendingSplitsState(false), PendingSplitsStateSerializerTest.getTestHybridPendingSplitsState(true), PendingSplitsStateSerializerTest.getTestBinlogPendingSplitsState());
    }

    @Test
    public void testsSerializeAndDeserialize() throws Exception {
        Assert.assertEquals((Object)this.state, (Object)PendingSplitsStateSerializerTest.serializeAndDeserializeSourceEnumState(this.state));
    }

    @Test
    public void testTableSchemasAfterSerializeAndDeserialize() throws Exception {
        PendingSplitsState pendingSplitsState = PendingSplitsStateSerializerTest.serializeAndDeserializeSourceEnumState(this.state);
        if (pendingSplitsState instanceof SnapshotPendingSplitsState) {
            Assert.assertEquals(PendingSplitsStateSerializerTest.getTestTableSchema(tableId0, tableId1).keySet(), ((SnapshotPendingSplitsState)pendingSplitsState).getTableSchemas().keySet());
        } else if (pendingSplitsState instanceof HybridPendingSplitsState) {
            Assert.assertEquals(PendingSplitsStateSerializerTest.getTestTableSchema(tableId0, tableId1).keySet(), ((HybridPendingSplitsState)pendingSplitsState).getSnapshotPendingSplits().getTableSchemas().keySet());
        }
    }

    @Test
    public void testRepeatedSerializationCache() throws Exception {
        PendingSplitsStateSerializer serializer = new PendingSplitsStateSerializer((SimpleVersionedSerializer)MySqlSplitSerializer.INSTANCE);
        byte[] ser1 = serializer.serialize(this.state);
        byte[] ser2 = serializer.serialize(this.state);
        byte[] ser3 = this.state.serializedFormCache;
        Assert.assertSame((Object)ser1, (Object)ser2);
        Assert.assertSame((Object)ser1, (Object)ser3);
    }

    static PendingSplitsState serializeAndDeserializeSourceEnumState(PendingSplitsState state) throws Exception {
        PendingSplitsStateSerializer serializer = new PendingSplitsStateSerializer((SimpleVersionedSerializer)MySqlSplitSerializer.INSTANCE);
        byte[] serialized = serializer.serialize(state);
        return serializer.deserialize(serializer.getVersion(), serialized);
    }

    private static SnapshotPendingSplitsState getTestSnapshotPendingSplitsState(boolean checkpointWhenSplitting) {
        ArrayList<TableId> alreadyProcessedTables = new ArrayList<TableId>();
        ArrayList<TableId> remainingTables = new ArrayList<TableId>();
        ArrayList<MySqlSchemalessSnapshotSplit> remainingSplits = new ArrayList<MySqlSchemalessSnapshotSplit>();
        alreadyProcessedTables.add(tableId0);
        alreadyProcessedTables.add(tableId1);
        remainingTables.add(tableId2);
        remainingSplits.add(PendingSplitsStateSerializerTest.getTestSchemalessSnapshotSplit(tableId1, 2));
        remainingSplits.add(PendingSplitsStateSerializerTest.getTestSchemalessSnapshotSplit(tableId1, 3));
        HashMap assignedSnapshotSplits = new HashMap();
        Arrays.asList(PendingSplitsStateSerializerTest.getTestSchemalessSnapshotSplit(tableId0, 0), PendingSplitsStateSerializerTest.getTestSchemalessSnapshotSplit(tableId0, 1), PendingSplitsStateSerializerTest.getTestSchemalessSnapshotSplit(tableId0, 2), PendingSplitsStateSerializerTest.getTestSchemalessSnapshotSplit(tableId1, 0), PendingSplitsStateSerializerTest.getTestSchemalessSnapshotSplit(tableId1, 1)).forEach(split -> assignedSnapshotSplits.put(split.splitId(), split));
        HashMap finishedOffsets = new HashMap();
        Arrays.asList(PendingSplitsStateSerializerTest.getTestSplitInfo(tableId0, 0), PendingSplitsStateSerializerTest.getTestSplitInfo(tableId0, 1), PendingSplitsStateSerializerTest.getTestSplitInfo(tableId1, 0), PendingSplitsStateSerializerTest.getTestSplitInfo(tableId1, 1), PendingSplitsStateSerializerTest.getTestSplitInfo(tableId0, 2)).forEach(finishedOffsets::putAll);
        Map<TableId, TableChanges.TableChange> tableSchemas = PendingSplitsStateSerializerTest.getTestTableSchema(tableId0, tableId1);
        if (checkpointWhenSplitting) {
            return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSplits, assignedSnapshotSplits, tableSchemas, finishedOffsets, AssignerStatus.INITIAL_ASSIGNING, remainingTables, false, true, new ChunkSplitterState(tableId1, ChunkSplitterState.ChunkBound.middleOf((Object)"test"), Integer.valueOf(3)));
        }
        return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSplits, assignedSnapshotSplits, tableSchemas, finishedOffsets, AssignerStatus.INITIAL_ASSIGNING, remainingTables, false, true, ChunkSplitterState.NO_SPLITTING_TABLE_STATE);
    }

    private static HybridPendingSplitsState getTestHybridPendingSplitsState(boolean checkpointWhenSplitting) {
        return new HybridPendingSplitsState(PendingSplitsStateSerializerTest.getTestSnapshotPendingSplitsState(checkpointWhenSplitting), false);
    }

    private static BinlogPendingSplitsState getTestBinlogPendingSplitsState() {
        return new BinlogPendingSplitsState(true);
    }

    private static MySqlSchemalessSnapshotSplit getTestSchemalessSnapshotSplit(TableId tableId, int splitNo) {
        return new MySqlSchemalessSnapshotSplit(tableId, tableId.toString() + "-" + splitNo, new RowType(Collections.singletonList(new RowType.RowField("id", (LogicalType)new BigIntType()))), new Object[]{100L + (long)splitNo * 1000L}, new Object[]{999L + (long)splitNo * 1000L}, BinlogOffset.builder().setBinlogFilePosition("mysql-bin.000001", 78L + (long)splitNo * 200L).setSkipEvents((long)splitNo).build());
    }

    private static Map<String, BinlogOffset> getTestSplitInfo(TableId tableId, int splitNo) {
        String splitId = tableId.toString() + "-" + splitNo;
        BinlogOffset highWatermark = BinlogOffset.ofBinlogFilePosition((String)"mysql-bin.000001", (long)((long)splitNo * 200L));
        return Collections.singletonMap(splitId, highWatermark);
    }

    private static Map<TableId, TableChanges.TableChange> getTestTableSchema(TableId ... tableIds) {
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        for (TableId tableId : tableIds) {
            tableSchemas.put(tableId, new TableChanges.TableChange(TableChanges.TableChangeType.CREATE, (Table)new TestTableImpl(tableId)));
        }
        return tableSchemas;
    }

    private static class TestTableImpl
    implements Table {
        private final TableId tableId;

        public TestTableImpl(TableId tableId) {
            this.tableId = tableId;
        }

        public TableId id() {
            return this.tableId;
        }

        public List<String> primaryKeyColumnNames() {
            return Collections.emptyList();
        }

        public List<String> retrieveColumnNames() {
            return Collections.emptyList();
        }

        public List<Column> columns() {
            return Collections.emptyList();
        }

        public Column columnWithName(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public String defaultCharsetName() {
            return "UTF-8";
        }

        public String comment() {
            return "";
        }

        public TableEditor edit() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

