/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.assigners;

import io.debezium.relational.TableId;
import java.util.List;
import org.apache.flink.cdc.connectors.mysql.source.assigners.ChunkRange;
import org.apache.flink.cdc.connectors.mysql.source.assigners.MySqlChunkSplitter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MySqlChunkSplitterTest {
    @Test
    public void testSplitEvenlySizedChunksOverflow() {
        MySqlChunkSplitter splitter = new MySqlChunkSplitter(null, null);
        List res = splitter.splitEvenlySizedChunks(new TableId("catalog", "db", "tab"), (Object)2147483628, (Object)Integer.MAX_VALUE, 20L, 10, 10);
        Assertions.assertEquals((int)2, (int)res.size());
        Assertions.assertEquals((Object)ChunkRange.of(null, (Object)0x7FFFFFF6), res.get(0));
        Assertions.assertEquals((Object)ChunkRange.of((Object)0x7FFFFFF6, null), res.get(1));
    }

    @Test
    public void testSplitEvenlySizedChunksNormal() {
        MySqlChunkSplitter splitter = new MySqlChunkSplitter(null, null);
        List res = splitter.splitEvenlySizedChunks(new TableId("catalog", "db", "tab"), (Object)2147483627, (Object)Integer.MAX_VALUE, 20L, 10, 10);
        Assertions.assertEquals((int)3, (int)res.size());
        Assertions.assertEquals((Object)ChunkRange.of(null, (Object)0x7FFFFFF5), res.get(0));
        Assertions.assertEquals((Object)ChunkRange.of((Object)0x7FFFFFF5, (Object)Integer.MAX_VALUE), res.get(1));
        Assertions.assertEquals((Object)ChunkRange.of((Object)Integer.MAX_VALUE, null), res.get(2));
    }
}

