/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.assigners;

import java.time.ZoneId;
import java.util.Optional;
import org.apache.flink.cdc.connectors.mysql.source.assigners.MySqlBinlogSplitAssigner;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.apache.flink.cdc.connectors.mysql.table.StartupOptions;
import org.junit.Assert;
import org.junit.Test;

public class MySqlBinlogSplitAssignerTest {
    @Test
    public void testStartFromEarliest() {
        this.checkAssignedBinlogOffset(StartupOptions.earliest(), BinlogOffset.ofEarliest());
    }

    @Test
    public void testStartFromLatestOffset() {
        this.checkAssignedBinlogOffset(StartupOptions.latest(), BinlogOffset.ofLatest());
    }

    @Test
    public void testStartFromTimestamp() {
        this.checkAssignedBinlogOffset(StartupOptions.timestamp((long)15213000L), BinlogOffset.ofTimestampSec((long)15213L));
    }

    @Test
    public void testStartFromBinlogFile() {
        this.checkAssignedBinlogOffset(StartupOptions.specificOffset((String)"foo-file", (long)15213L), BinlogOffset.ofBinlogFilePosition((String)"foo-file", (long)15213L));
    }

    @Test
    public void testStartFromGtidSet() {
        this.checkAssignedBinlogOffset(StartupOptions.specificOffset((String)"foo-gtid"), BinlogOffset.ofGtidSet((String)"foo-gtid"));
    }

    private void checkAssignedBinlogOffset(StartupOptions startupOptions, BinlogOffset expectedOffset) {
        MySqlBinlogSplitAssigner assigner = new MySqlBinlogSplitAssigner(this.getConfig(startupOptions));
        Optional optionalSplit = assigner.getNext();
        Assert.assertTrue((boolean)optionalSplit.isPresent());
        MySqlBinlogSplit split = ((MySqlSplit)optionalSplit.get()).asBinlogSplit();
        Assert.assertEquals((Object)expectedOffset, (Object)split.getStartingOffset());
        Assert.assertEquals((Object)BinlogOffset.ofNonStopping(), (Object)split.getEndingOffset());
        Assert.assertFalse((boolean)assigner.getNext().isPresent());
        assigner.close();
    }

    private MySqlSourceConfig getConfig(StartupOptions startupOptions) {
        return new MySqlSourceConfigFactory().startupOptions(startupOptions).databaseList(new String[]{"foo-db"}).tableList(new String[]{"foo-table"}).hostname("foo-host").port(15213).username("jane-doe").password("password").serverTimeZone(ZoneId.of("UTC").toString()).createConfig(0);
    }
}

