/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSource;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSourceTestBase;
import org.apache.flink.cdc.connectors.mysql.testutils.UniqueDatabase;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.JsonDebeziumDeserializationSchema;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.junit.Ignore;
import org.junit.Test;

public class MySqlSourceExampleTest
extends MySqlSourceTestBase {
    private final UniqueDatabase inventoryDatabase = new UniqueDatabase(MYSQL_CONTAINER, "inventory", "mysqluser", "mysqlpw");

    @Test
    @Ignore(value="Test ignored because it won't stop and is used for manual test")
    public void testConsumingAllEvents() throws Exception {
        this.inventoryDatabase.createAndInitialize();
        MySqlSource mySqlSource = MySqlSource.builder().hostname(MYSQL_CONTAINER.getHost()).port(MYSQL_CONTAINER.getDatabasePort()).databaseList(new String[]{this.inventoryDatabase.getDatabaseName()}).tableList(new String[]{this.inventoryDatabase.getDatabaseName() + ".products"}).username(this.inventoryDatabase.getUsername()).password(this.inventoryDatabase.getPassword()).serverId("5401-5404").deserializer((DebeziumDeserializationSchema)new JsonDebeziumDeserializationSchema()).serverTimeZone("UTC").includeSchemaChanges(true).build();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(3000L);
        env.fromSource((Source)mySqlSource, WatermarkStrategy.noWatermarks(), "MySqlParallelSource").setParallelism(4).print().setParallelism(1);
        env.execute("Print MySQL Snapshot + Binlog");
    }
}

