/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.debezium;

import io.debezium.connector.mysql.MySqlConnection;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Properties;
import org.apache.flink.cdc.connectors.mysql.debezium.DebeziumUtils;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import org.apache.flink.cdc.connectors.mysql.table.StartupOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DebeziumUtilsTest {
    @Test
    void testCreateMySqlConnection() {
        Properties jdbcProps = new Properties();
        jdbcProps.setProperty("onlyTest", "test");
        MySqlSourceConfig configWithoutUseSSL = this.getConfig(jdbcProps);
        MySqlConnection connection0 = DebeziumUtils.createMySqlConnection((MySqlSourceConfig)configWithoutUseSSL);
        this.assertJdbcUrl("jdbc:mysql://localhost:3306/?useSSL=false&connectTimeout=20000&useInformationSchema=true&nullCatalogMeansCurrent=false&characterSetResults=UTF-8&onlyTest=test&zeroDateTimeBehavior=CONVERT_TO_NULL&characterEncoding=UTF-8&useUnicode=true", connection0.connectionString());
        jdbcProps.setProperty("useSSL", "false");
        MySqlSourceConfig configNotUseSSL = this.getConfig(jdbcProps);
        MySqlConnection connection1 = DebeziumUtils.createMySqlConnection((MySqlSourceConfig)configNotUseSSL);
        this.assertJdbcUrl("jdbc:mysql://localhost:3306/?connectTimeout=20000&useInformationSchema=true&nullCatalogMeansCurrent=false&characterSetResults=UTF-8&useSSL=false&onlyTest=test&zeroDateTimeBehavior=CONVERT_TO_NULL&characterEncoding=UTF-8&useUnicode=true", connection1.connectionString());
        jdbcProps.setProperty("useSSL", "true");
        MySqlSourceConfig configUseSSL = this.getConfig(jdbcProps);
        MySqlConnection connection2 = DebeziumUtils.createMySqlConnection((MySqlSourceConfig)configUseSSL);
        this.assertJdbcUrl("jdbc:mysql://localhost:3306/?connectTimeout=20000&useInformationSchema=true&nullCatalogMeansCurrent=false&characterSetResults=UTF-8&useSSL=true&onlyTest=test&zeroDateTimeBehavior=CONVERT_TO_NULL&characterEncoding=UTF-8&useUnicode=true", connection2.connectionString());
    }

    private MySqlSourceConfig getConfig(Properties jdbcProperties) {
        return new MySqlSourceConfigFactory().startupOptions(StartupOptions.initial()).databaseList(new String[]{"fakeDb"}).tableList(new String[]{"fakeDb.fakeTable"}).includeSchemaChanges(false).hostname("localhost").port(3306).splitSize(10).fetchSize(2).connectTimeout(Duration.ofSeconds(20L)).username("fakeUser").password("fakePw").serverTimeZone(ZoneId.of("UTC").toString()).jdbcProperties(jdbcProperties).createConfig(0);
    }

    private void assertJdbcUrl(String expected, String actual) {
        Object[] expectedParam = expected.split("&");
        Arrays.sort(expectedParam);
        Object[] actualParam = actual.split("&");
        Arrays.sort(actualParam);
        Assertions.assertArrayEquals((Object[])expectedParam, (Object[])actualParam);
    }
}

