/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.BroadcastState;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.mysql.MySqlSource;
import org.apache.flink.cdc.connectors.mysql.testutils.UniqueDatabase;
import org.apache.flink.cdc.connectors.utils.TestSourceContext;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;

public class MySqlTestUtils {
    public static MySqlSource.Builder<SourceRecord> basicSourceBuilder(UniqueDatabase database, String serverTimezone, boolean useLegacyImplementation) {
        Properties debeziumProps = MySqlTestUtils.createDebeziumProperties(useLegacyImplementation);
        return MySqlSource.builder().hostname(database.getHost()).port(database.getDatabasePort()).databaseList(new String[]{database.getDatabaseName()}).tableList(new String[]{database.getDatabaseName() + ".products"}).username(database.getUsername()).password(database.getPassword()).deserializer((DebeziumDeserializationSchema)new ForwardDeserializeSchema()).serverTimeZone(serverTimezone).debeziumProperties(debeziumProps);
    }

    public static <T> void setupSource(DebeziumSourceFunction<T> source) throws Exception {
        MySqlTestUtils.setupSource(source, false, null, null, true, 0, 1);
    }

    public static <T, S1, S2> void setupSource(DebeziumSourceFunction<T> source, boolean isRestored, ListState<S1> restoredOffsetState, ListState<S2> restoredHistoryState, boolean isCheckpointingEnabled, int subtaskIndex, int totalNumSubtasks) throws Exception {
        source.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(isCheckpointingEnabled, totalNumSubtasks, subtaskIndex));
        source.initializeState((FunctionInitializationContext)new MockFunctionInitializationContext(isRestored, new MockOperatorStateStore(restoredOffsetState, restoredHistoryState)));
        source.open(new Configuration());
    }

    public static <T> List<T> drain(TestSourceContext<T> sourceContext, int expectedRecordCount) throws Exception {
        ArrayList<Object> allRecords = new ArrayList<Object>();
        LinkedBlockingQueue queue = sourceContext.getCollectedOutputs();
        while (allRecords.size() < expectedRecordCount) {
            StreamRecord record = (StreamRecord)queue.poll(100L, TimeUnit.SECONDS);
            if (record != null) {
                allRecords.add(record.getValue());
                continue;
            }
            throw new RuntimeException("Can't receive " + expectedRecordCount + " elements before timeout.");
        }
        return allRecords;
    }

    public static void waitUntilCondition(SupplierWithException<Boolean, Exception> condition, Deadline timeout, long retryIntervalMillis, String errorMsg) throws Exception {
        while (timeout.hasTimeLeft() && !((Boolean)condition.get()).booleanValue()) {
            long timeLeft = Math.max(0L, timeout.timeLeft().toMillis());
            Thread.sleep(Math.min(retryIntervalMillis, timeLeft));
        }
        if (!timeout.hasTimeLeft()) {
            throw new TimeoutException(errorMsg);
        }
    }

    public static void waitForJobStatus(JobClient client, List<JobStatus> expectedStatus, Deadline deadline) throws Exception {
        MySqlTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            JobStatus currentStatus = (JobStatus)client.getJobStatus().get();
            if (expectedStatus.contains(currentStatus)) {
                return true;
            }
            if (currentStatus.isTerminalState()) {
                try {
                    client.getJobExecutionResult().get();
                }
                catch (Exception var4) {
                    throw new IllegalStateException(String.format("Job has entered %s state, but expecting %s", currentStatus, expectedStatus), var4);
                }
                throw new IllegalStateException(String.format("Job has entered a terminal state %s, but expecting %s", currentStatus, expectedStatus));
            }
            return false;
        }), deadline, 100L, "Condition was not met in given timeout.");
    }

    private static Properties createDebeziumProperties(boolean useLegacyImplementation) {
        Properties debeziumProps = new Properties();
        if (useLegacyImplementation) {
            debeziumProps.put("internal.implementation", "legacy");
            debeziumProps.put("transforms", "snapshotasinsert");
            debeziumProps.put("transforms.snapshotasinsert.type", "io.debezium.connector.mysql.transforms.ReadToInsertEvent");
        }
        return debeziumProps;
    }

    public static void assertContainsErrorMsg(Throwable t, String errorMsg) {
        boolean findFixMsg = false;
        for (Throwable temp = t; temp != null; temp = temp.getCause()) {
            boolean bl = findFixMsg = findFixMsg || temp.getMessage().contains(errorMsg);
            if (findFixMsg) break;
        }
        Assert.assertTrue((boolean)findFixMsg);
    }

    static final class TestingListState<T>
    implements ListState<T> {
        public final List<T> list = new ArrayList<T>();
        private boolean clearCalled = false;

        TestingListState() {
        }

        public void clear() {
            this.list.clear();
            this.clearCalled = true;
        }

        public Iterable<T> get() {
            return this.list;
        }

        public void add(T value) {
            Preconditions.checkNotNull(value, (String)"You cannot add null to a ListState.");
            this.list.add(value);
        }

        public List<T> getList() {
            return this.list;
        }

        boolean isClearCalled() {
            return this.clearCalled;
        }

        public void update(List<T> values) {
            this.clear();
            this.addAll(values);
        }

        public void addAll(List<T> values) {
            if (values != null) {
                values.forEach(v -> Preconditions.checkNotNull((Object)v, (String)"You cannot add null to a ListState."));
                this.list.addAll(values);
            }
        }
    }

    private static class MockFunctionInitializationContext
    implements FunctionInitializationContext {
        private final boolean isRestored;
        private final OperatorStateStore operatorStateStore;

        private MockFunctionInitializationContext(boolean isRestored, OperatorStateStore operatorStateStore) {
            this.isRestored = isRestored;
            this.operatorStateStore = operatorStateStore;
        }

        public boolean isRestored() {
            return this.isRestored;
        }

        public OptionalLong getRestoredCheckpointId() {
            throw new UnsupportedOperationException();
        }

        public OperatorStateStore getOperatorStateStore() {
            return this.operatorStateStore;
        }

        public KeyedStateStore getKeyedStateStore() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockOperatorStateStore
    implements OperatorStateStore {
        private final ListState<?> restoredOffsetListState;
        private final ListState<?> restoredHistoryListState;

        private MockOperatorStateStore(ListState<?> restoredOffsetListState, ListState<?> restoredHistoryListState) {
            this.restoredOffsetListState = restoredOffsetListState;
            this.restoredHistoryListState = restoredHistoryListState;
        }

        public <S> ListState<S> getUnionListState(ListStateDescriptor<S> stateDescriptor) {
            if (stateDescriptor.getName().equals("offset-states")) {
                return this.restoredOffsetListState;
            }
            if (stateDescriptor.getName().equals("history-records-states")) {
                return this.restoredHistoryListState;
            }
            throw new IllegalStateException("Unknown state.");
        }

        public <K, V> BroadcastState<K, V> getBroadcastState(MapStateDescriptor<K, V> stateDescriptor) {
            throw new UnsupportedOperationException();
        }

        public <S> ListState<S> getListState(ListStateDescriptor<S> stateDescriptor) {
            throw new UnsupportedOperationException();
        }

        public Set<String> getRegisteredStateNames() {
            throw new UnsupportedOperationException();
        }

        public Set<String> getRegisteredBroadcastStateNames() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ForwardDeserializeSchema
    implements DebeziumDeserializationSchema<SourceRecord> {
        private static final long serialVersionUID = 2975058057832211228L;

        public void deserialize(SourceRecord record, Collector<SourceRecord> out) {
            out.collect((Object)record);
        }

        public TypeInformation<SourceRecord> getProducedType() {
            return TypeInformation.of(SourceRecord.class);
        }
    }
}

