/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.GtidUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class GtidUtilsTest {
    GtidUtilsTest() {
    }

    @Test
    void testFixingRestoredGtidSet() {
        GtidSet serverGtidSet = new GtidSet("A:1-100");
        GtidSet restoredGtidSet = new GtidSet("A:30-100");
        Assertions.assertThat((String)GtidUtils.fixRestoredGtidSet((GtidSet)serverGtidSet, (GtidSet)restoredGtidSet).toString()).isEqualTo("A:1-100");
        serverGtidSet = new GtidSet("A:1-100");
        restoredGtidSet = new GtidSet("A:30-50");
        Assertions.assertThat((String)GtidUtils.fixRestoredGtidSet((GtidSet)serverGtidSet, (GtidSet)restoredGtidSet).toString()).isEqualTo("A:1-50");
        serverGtidSet = new GtidSet("A:1-100:102-200,B:20-200");
        restoredGtidSet = new GtidSet("A:106-150");
        Assertions.assertThat((String)GtidUtils.fixRestoredGtidSet((GtidSet)serverGtidSet, (GtidSet)restoredGtidSet).toString()).isEqualTo("A:1-100:102-150,B:20-200");
        serverGtidSet = new GtidSet("A:1-100:102-200,B:20-200");
        restoredGtidSet = new GtidSet("A:106-150,C:1-100");
        Assertions.assertThat((String)GtidUtils.fixRestoredGtidSet((GtidSet)serverGtidSet, (GtidSet)restoredGtidSet).toString()).isEqualTo("A:1-100:102-150,B:20-200,C:1-100");
        serverGtidSet = new GtidSet("A:1-100:102-200,B:20-200");
        restoredGtidSet = new GtidSet("A:106-150:152-200,C:1-100");
        Assertions.assertThat((String)GtidUtils.fixRestoredGtidSet((GtidSet)serverGtidSet, (GtidSet)restoredGtidSet).toString()).isEqualTo("A:1-100:102-200,B:20-200,C:1-100");
    }

    @Test
    void testMergingGtidSets() {
        GtidSet base = new GtidSet("A:1-100");
        GtidSet toMerge = new GtidSet("A:1-10");
        Assertions.assertThat((String)GtidUtils.mergeGtidSetInto((GtidSet)base, (GtidSet)toMerge).toString()).isEqualTo("A:1-100");
        base = new GtidSet("A:1-100");
        toMerge = new GtidSet("B:1-10");
        Assertions.assertThat((String)GtidUtils.mergeGtidSetInto((GtidSet)base, (GtidSet)toMerge).toString()).isEqualTo("A:1-100,B:1-10");
        base = new GtidSet("A:1-100,C:1-100");
        toMerge = new GtidSet("A:1-10,B:1-10");
        Assertions.assertThat((String)GtidUtils.mergeGtidSetInto((GtidSet)base, (GtidSet)toMerge).toString()).isEqualTo("A:1-100,B:1-10,C:1-100");
    }
}

