/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventMetadata;
import com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventMetadataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TableMapEventDataDeserializerTest {
    @Test
    public void testDeserialize() throws IOException {
        TableMapEventDataDeserializer deserializer = new TableMapEventDataDeserializer();
        byte[] data = new byte[]{1, 0, 0, 0, 0, 0, 1, 0, 6, 116, 101, 115, 116, 68, 98, 0, 9, 116, 101, 115, 116, 84, 97, 98, 108, 101, 0, 3, 8, 1, 20, 1, 8, 80, 1, 1, 0, 2, 1, 45};
        TableMapEventData eventData = deserializer.deserialize(new ByteArrayInputStream(data));
        Assertions.assertThat((String)eventData.toString()).isEqualTo(this.getExpectedEventData().toString());
    }

    @Test
    public void testDeserializeMetadata() throws IOException {
        byte[] data = new byte[]{1, 5, -74, -39, -101, 97, 0, 3, 32, 33, 33, 63, 33, 63, 63, 63, 63, -4, -1, 0, -4, -1, 0, -4, -1, 0, -4, -1, 0, -4, -1, 0, -4, -1, 0, -4, -1, 0, -4, -1, 0};
        TableMapEventMetadataDeserializer deserializer = new TableMapEventMetadataDeserializer();
        TableMapEventMetadata metadata = deserializer.deserialize(new ByteArrayInputStream(data), 59, 32);
        Assertions.assertThat((String)metadata.toString()).isEqualTo(this.getExpectedTableMapEventMetaData().toString());
    }

    private TableMapEventData getExpectedEventData() {
        TableMapEventData eventData = new TableMapEventData();
        eventData.setTableId(1L);
        eventData.setDatabase("testDb");
        eventData.setTable("testTable");
        eventData.setColumnTypes(new byte[]{8, 1, 20});
        eventData.setColumnMetadata(new int[]{0, 0, 0});
        eventData.setColumnNullability(new BitSet());
        TableMapEventMetadata metadata = new TableMapEventMetadata();
        metadata.setSignedness(new BitSet());
        TableMapEventMetadata.DefaultCharset charset = new TableMapEventMetadata.DefaultCharset();
        charset.setDefaultCharsetCollation(45);
        metadata.setDefaultCharset(charset);
        eventData.setEventMetadata(metadata);
        return eventData;
    }

    private TableMapEventMetadata getExpectedTableMapEventMetaData() {
        TableMapEventMetadata metadata = new TableMapEventMetadata();
        BitSet signedness = new BitSet();
        List<Integer> signedBits = Arrays.asList(0, 2, 3, 5, 6, 8, 9, 11, 12, 15, 16, 19, 20, 22, 23, 25, 26, 31);
        for (Integer signedBit : signedBits) {
            signedness.set(signedBit);
        }
        metadata.setSignedness(signedness);
        metadata.setColumnCharsets(Arrays.asList(33, 33, 63, 33, 63, 63, 63, 63, 255, 255, 255, 255, 255, 255, 255, 255));
        return metadata;
    }
}

