/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.enumerator.splitter;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.common.utils.MongoUtils;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSampleSplitter;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoShardedSplitter;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSingleSplitter;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSplitContext;
import org.apache.flink.connector.mongodb.source.enumerator.splitter.MongoSplitVectorSplitter;
import org.apache.flink.connector.mongodb.source.split.MongoScanSourceSplit;
import org.apache.flink.util.FlinkRuntimeException;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoSplitters {
    private static final Logger LOG = LoggerFactory.getLogger(MongoSplitters.class);

    private MongoSplitters() {
    }

    public static Collection<MongoScanSourceSplit> split(MongoClient mongoClient, MongoReadOptions readOptions, MongoNamespace namespace) {
        BsonDocument collStats;
        try {
            collStats = MongoUtils.collStats(mongoClient, namespace);
        }
        catch (MongoException e) {
            LOG.error("Execute collStats command failed, with error message: {}", (Object)e.getMessage());
            throw new FlinkRuntimeException((Throwable)e);
        }
        MongoSplitContext splitContext = MongoSplitContext.of(readOptions, mongoClient, namespace, collStats);
        switch (readOptions.getPartitionStrategy()) {
            case SINGLE: {
                return MongoSingleSplitter.split(splitContext);
            }
            case SAMPLE: {
                return MongoSampleSplitter.split(splitContext);
            }
            case SPLIT_VECTOR: {
                return MongoSplitVectorSplitter.split(splitContext);
            }
            case SHARDED: {
                return MongoShardedSplitter.split(splitContext);
            }
        }
        return splitContext.isSharded() ? MongoShardedSplitter.split(splitContext) : MongoSplitVectorSplitter.split(splitContext);
    }
}

