/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.common.utils;

import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@Internal
public class MongoUtils {
    private static final String COLL_STATS_COMMAND = "collStats";
    private static final String SPLIT_VECTOR_COMMAND = "splitVector";
    private static final String KEY_PATTERN_OPTION = "keyPattern";
    private static final String MAX_CHUNK_SIZE_OPTION = "maxChunkSize";
    private static final String CONFIG_DATABASE = "config";
    private static final String COLLECTIONS_COLLECTION = "collections";
    private static final String CHUNKS_COLLECTION = "chunks";

    private MongoUtils() {
    }

    public static BsonDocument collStats(MongoClient mongoClient, MongoNamespace namespace) {
        BsonDocument collStatsCommand = new BsonDocument(COLL_STATS_COMMAND, (BsonValue)new BsonString(namespace.getCollectionName()));
        return (BsonDocument)mongoClient.getDatabase(namespace.getDatabaseName()).runCommand((Bson)collStatsCommand, BsonDocument.class);
    }

    public static BsonDocument splitVector(MongoClient mongoClient, MongoNamespace namespace, BsonDocument keyPattern, int maxChunkSizeMB) {
        return MongoUtils.splitVector(mongoClient, namespace, keyPattern, maxChunkSizeMB, null, null);
    }

    public static BsonDocument splitVector(MongoClient mongoClient, MongoNamespace namespace, BsonDocument keyPattern, int maxChunkSizeMB, @Nullable BsonDocument min, @Nullable BsonDocument max) {
        BsonDocument splitVectorCommand = new BsonDocument(SPLIT_VECTOR_COMMAND, (BsonValue)new BsonString(namespace.getFullName())).append(KEY_PATTERN_OPTION, (BsonValue)keyPattern).append(MAX_CHUNK_SIZE_OPTION, (BsonValue)new BsonInt32(maxChunkSizeMB));
        Optional.ofNullable(min).ifPresent(v -> splitVectorCommand.append("min", (BsonValue)v));
        Optional.ofNullable(max).ifPresent(v -> splitVectorCommand.append("max", (BsonValue)v));
        return (BsonDocument)mongoClient.getDatabase(namespace.getDatabaseName()).runCommand((Bson)splitVectorCommand, BsonDocument.class);
    }

    public static Optional<BsonDocument> readCollectionMetadata(MongoClient mongoClient, MongoNamespace namespace) {
        MongoCollection collections = mongoClient.getDatabase(CONFIG_DATABASE).getCollection(COLLECTIONS_COLLECTION).withDocumentClass(BsonDocument.class);
        return Optional.ofNullable(collections.find(Filters.eq((String)"_id", (Object)namespace.getFullName())).projection(Projections.include((String[])new String[]{"_id", "uuid", "dropped", "key"})).first());
    }

    public static boolean isShardedCollectionDropped(BsonDocument collectionMetadata) {
        return collectionMetadata.getBoolean((Object)"dropped", BsonBoolean.FALSE).getValue();
    }

    public static List<BsonDocument> readChunks(MongoClient mongoClient, BsonDocument collectionMetadata) {
        MongoCollection chunks = mongoClient.getDatabase(CONFIG_DATABASE).getCollection(CHUNKS_COLLECTION).withDocumentClass(BsonDocument.class);
        Bson filter = Filters.or((Bson[])new Bson[]{new BsonDocument("ns", collectionMetadata.get((Object)"_id")), new BsonDocument("uuid", collectionMetadata.get((Object)"uuid"))});
        return (List)chunks.find(filter).projection(Projections.include((String[])new String[]{"min", "max", "shard"})).sort(Sorts.ascending((String[])new String[]{"min"})).into(new ArrayList());
    }

    public static Bson project(List<String> projectedFields) {
        if (projectedFields.contains("_id")) {
            return Projections.include(projectedFields);
        }
        return Projections.fields((Bson[])new Bson[]{Projections.include(projectedFields), Projections.excludeId()});
    }
}

