/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.reader;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;
import org.apache.flink.util.UserCodeClassLoader;

@Internal
public class MongoSourceReaderContext
implements SourceReaderContext {
    private final SourceReaderContext readerContext;
    private final AtomicInteger readCount = new AtomicInteger(0);
    private final int limit;

    public MongoSourceReaderContext(SourceReaderContext readerContext, int limit) {
        this.readerContext = readerContext;
        this.limit = limit;
    }

    public SourceReaderMetricGroup metricGroup() {
        return this.readerContext.metricGroup();
    }

    public Configuration getConfiguration() {
        return this.readerContext.getConfiguration();
    }

    public String getLocalHostName() {
        return this.readerContext.getLocalHostName();
    }

    public int getIndexOfSubtask() {
        return this.readerContext.getIndexOfSubtask();
    }

    public void sendSplitRequest() {
        this.readerContext.sendSplitRequest();
    }

    public void sendSourceEventToCoordinator(SourceEvent sourceEvent) {
        this.readerContext.sendSourceEventToCoordinator(sourceEvent);
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        return this.readerContext.getUserCodeClassLoader();
    }

    public AtomicInteger getReadCount() {
        return this.readCount;
    }

    public boolean isLimitPushedDown() {
        return this.limit > 0;
    }

    public boolean isOverLimit() {
        return this.limit > 0 && this.readCount.get() >= this.limit;
    }

    public int getLimit() {
        return this.limit;
    }
}

